/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.mention;

import com.hanhy06.embellish_chat.config.Config;
import com.hanhy06.embellish_chat.config.ConfigListener;
import com.hanhy06.embellish_chat.mention.MentionTarget;
import com.hanhy06.embellish_chat.mention.ParsedMention;
import com.hanhy06.embellish_chat.util.TeamColor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5250;

public class MentionProcessor
implements ConfigListener {
    private static final Pattern MENTION_PATTERN = Pattern.compile("@([A-Za-z0-9_]{1,16})(?=\\b|$)");
    private final class_3324 manager;
    private final class_269 scoreboard;
    private Config config;
    private class_3414 mentionSound;

    @Override
    public void onConfigReload(Config newConfig) {
        this.config = newConfig;
        this.mentionSound = class_3414.method_47908((class_2960)class_2960.method_12829((String)this.config.mentionSound()));
    }

    public MentionProcessor(class_3324 manager, class_269 scoreboard) {
        this.manager = manager;
        this.scoreboard = scoreboard;
    }

    public void broadcastMention(class_3222 sender, List<MentionTarget> targets) {
        class_5250 titleText = class_2561.method_43473();
        titleText.method_10852((class_2561)class_2561.method_43470((String)this.config.mentionTitlePrefix()).method_27694(style -> style.method_10982(Boolean.valueOf(false)).method_36139(0xFFFFFF)));
        titleText.method_10852((class_2561)sender.method_5477().method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_36139(TeamColor.getPlayerColor(sender))));
        titleText.method_10852((class_2561)class_2561.method_43470((String)this.config.mentionTitleSuffix()).method_27694(style -> style.method_10982(Boolean.valueOf(false)).method_36139(0xFFFFFF)));
        for (MentionTarget target : targets) {
            if (target.players() == null || target.players().isEmpty()) continue;
            for (class_3222 player : target.players()) {
                player.method_17356(this.mentionSound, class_3419.field_61058, 1.0f, this.config.mentionPitch());
                player.method_7353((class_2561)titleText, true);
            }
        }
    }

    public List<ParsedMention> parseMentions(String raw) {
        Matcher matcher = MENTION_PATTERN.matcher(raw);
        ArrayList<ParsedMention> parsedMentions = new ArrayList<ParsedMention>();
        while (matcher.find()) {
            parsedMentions.add(new ParsedMention(matcher.group(1), matcher.start(), matcher.end(1)));
        }
        return parsedMentions;
    }

    public List<MentionTarget> identifyMentionTargets(class_3222 sender, List<ParsedMention> parsedMentions) {
        ArrayList<MentionTarget> targets = new ArrayList<MentionTarget>();
        boolean canGroupMention = this.canUseGroupMention(sender);
        for (ParsedMention parsedMention : parsedMentions) {
            String name = parsedMention.name();
            if (canGroupMention) {
                switch (name) {
                    case "everyone": {
                        targets.add(this.everyone(parsedMention));
                        break;
                    }
                    case "here": {
                        targets.add(this.here(sender, parsedMention));
                        break;
                    }
                    case "team": {
                        targets.add(this.team(sender, parsedMention));
                        break;
                    }
                    default: {
                        targets.add(this.player(parsedMention));
                        break;
                    }
                }
                continue;
            }
            targets.add(this.player(parsedMention));
        }
        return targets;
    }

    private MentionTarget everyone(ParsedMention parsedMention) {
        return new MentionTarget("everyone", parsedMention.begin(), parsedMention.end(), this.config.groupMentionColor(), this.manager.method_14571());
    }

    private MentionTarget here(class_3222 sender, ParsedMention parsedMention) {
        List<class_3222> players = PlayerLookup.around((class_3218)sender.method_51469(), (class_243)sender.method_19538(), (double)this.config.hereRadius()).stream().toList();
        return new MentionTarget("here", parsedMention.begin(), parsedMention.end(), this.config.groupMentionColor(), players);
    }

    private MentionTarget team(class_3222 sender, ParsedMention parsedMention) {
        class_268 team = sender.method_5781();
        if (team != null) {
            int color = this.config.groupMentionColor();
            class_124 formatting = team.method_1202();
            if (formatting != null && formatting.method_543() && formatting != class_124.field_1070) {
                color = formatting.method_532();
            }
            List<class_3222> players = team.method_1204().stream().map(arg_0 -> ((class_3324)this.manager).method_14566(arg_0)).filter(Objects::nonNull).toList();
            return new MentionTarget("team", parsedMention.begin(), parsedMention.end(), color, players);
        }
        return new MentionTarget("team", parsedMention.begin(), parsedMention.end(), this.config.groupMentionColor(), null);
    }

    private MentionTarget player(ParsedMention parsedMention) {
        class_3222 player = this.manager.method_14566(parsedMention.name());
        int teamColor = player != null ? TeamColor.getPlayerColor(player) : (this.config.offlineColorEnabled() ? TeamColor.getPlayerColor(this.scoreboard, parsedMention.name()) : this.config.mentionColor());
        return new MentionTarget(parsedMention.name(), parsedMention.begin(), parsedMention.end(), teamColor, player != null ? List.of(player) : null);
    }

    private boolean canUseGroupMention(class_3222 player) {
        return !this.config.groupMentionOpOnly() || this.manager.method_14569(player.method_7334());
    }
}

