/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.message;

import com.hanhy06.embellish_chat.config.Config;
import com.hanhy06.embellish_chat.config.ConfigListener;
import com.hanhy06.embellish_chat.mention.MentionProcessor;
import com.hanhy06.embellish_chat.mention.MentionTarget;
import com.hanhy06.embellish_chat.mention.ParsedMention;
import com.hanhy06.embellish_chat.styling.StylingProcessor;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_7471;

public class MessageProcessor
implements ConfigListener {
    public static MessageProcessor INSTANCE;
    private Config config;
    private List<UUID> bannedPlayerList;
    private final MentionProcessor mentionProcessor;
    private final StylingProcessor stylingManager;
    private final class_3324 playerManager;

    public MessageProcessor(MentionProcessor mentionProcessor, StylingProcessor stylingManager, class_3324 playerManager) {
        INSTANCE = this;
        this.mentionProcessor = mentionProcessor;
        this.stylingManager = stylingManager;
        this.playerManager = playerManager;
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.config = newConfig;
        this.bannedPlayerList = this.config.bannedPlayerList();
    }

    public class_7471 handleMessage(class_7471 message) {
        if (this.bannedPlayerList.contains(message.method_46292())) {
            return message;
        }
        class_3222 sender = this.playerManager.method_14602(message.method_46292());
        class_5250 finalMessage = message.method_46291().method_27661();
        String raw = message.method_46291().getString();
        List<MentionTarget> targets = List.of();
        if (this.config.mentionEnabled()) {
            targets = this.handleMentions(raw, sender);
            finalMessage = this.stylingManager.applyMention(finalMessage, targets);
        }
        finalMessage = this.stylingManager.applyStyles(finalMessage, "chat");
        return message.method_44863((class_2561)finalMessage);
    }

    private List<MentionTarget> handleMentions(String raw, class_3222 sender) {
        List<ParsedMention> parsedMentions = this.mentionProcessor.parseMentions(raw);
        List<MentionTarget> targets = this.mentionProcessor.identifyMentionTargets(sender, parsedMentions);
        if (!parsedMentions.isEmpty()) {
            this.mentionProcessor.broadcastMention(sender, targets);
        }
        return targets;
    }
}

