/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.styling;

import com.hanhy06.embellish_chat.EmbellishChat;
import com.hanhy06.embellish_chat.config.Config;
import com.hanhy06.embellish_chat.mention.MentionTarget;
import com.hanhy06.embellish_chat.styling.util.Runs;
import com.hanhy06.embellish_chat.styling.util.TextSliceUtil;
import com.hanhy06.embellish_chat.util.Timestamp;
import java.awt.Color;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class StyleRegistry {
    private final Config config;
    private final HashMap<String, Integer> colorPreset;

    public StyleRegistry(Config config) {
        this.config = config;
        this.colorPreset = config.colorPreset();
    }

    public class_5250 METADATA(class_5250 text, String option) {
        class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)(Timestamp.timeStamp() + "\nClick to copy to clipboard")));
        class_2558.class_10606 clickEvent = new class_2558.class_10606(text.getString());
        return text.method_27696(class_2583.field_24360.method_10949((class_2568)hoverEvent).method_10958((class_2558)clickEvent));
    }

    public static class_5250 MENTION(class_5250 text, List<MentionTarget> targets) {
        Runs runs = TextSliceUtil.flatten((class_2561)text);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        for (MentionTarget target : targets) {
            result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, target.begin()));
            result.method_10852((class_2561)TextSliceUtil.slice(runs, target.begin(), target.end()).method_27696(class_2583.field_24360.method_36139(target.teamColor()).method_10982(Boolean.valueOf(true))));
            lastEnd = target.end();
        }
        result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, runs.full().length()));
        return result;
    }

    public class_5250 COLOR_HEX(class_5250 text, String option) {
        int color = Color.decode(option).getRGB();
        return text.method_27696(class_2583.field_24360.method_36139(color));
    }

    public class_5250 COLOR_RAINBOW(class_5250 text, String option) {
        Runs runs = TextSliceUtil.flatten((class_2561)text);
        String string = runs.full();
        int length = string.length();
        if (length == 0) {
            return text;
        }
        class_5250 result = class_2561.method_43473();
        for (int i = 0; i < length; ++i) {
            float hue = (float)i / (float)length;
            int rgb = Color.HSBtoRGB(hue, 0.7f, 1.0f);
            result.method_10852((class_2561)TextSliceUtil.slice(runs, i, i + 1).method_27696(class_2583.field_24360.method_36139(rgb)));
        }
        return result;
    }

    public class_5250 COLOR_PRESET(class_5250 text, String option) {
        int color = this.colorPreset.getOrDefault(option, 0xFFFFFF);
        return text.method_27696(class_2583.field_24360.method_36139(color));
    }

    public class_5250 COLOR_SHADOW(class_5250 text, String option) {
        int color = Color.decode(option).getRGB();
        return text.method_27696(class_2583.field_24360.method_65302(color));
    }

    public class_5250 FONT(class_5250 text, String option) {
        return text.method_27696(class_2583.field_24360.method_27704(class_2960.method_12829((String)option)));
    }

    public class_5250 URL(class_5250 text, String option) {
        try {
            URI uri = URI.create(option);
            class_2558.class_10608 clickEvent = new class_2558.class_10608(uri);
            return text.method_27696(class_2583.field_24360.method_10958((class_2558)clickEvent).method_36139(this.config.urlColor()));
        }
        catch (IllegalArgumentException e) {
            EmbellishChat.LOGGER.warn("Invalid URL address: {}", (Object)option);
            return text;
        }
    }

    public class_5250 BOLD(class_5250 text, String option) {
        return text.method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
    }

    public class_5250 ITALIC(class_5250 text, String option) {
        return text.method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)));
    }

    public class_5250 UNDERLINE(class_5250 text, String option) {
        return text.method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
    }

    public class_5250 OBFUSCATED(class_5250 text, String option) {
        return text.method_27696(class_2583.field_24360.method_36141(Boolean.valueOf(true)));
    }

    public class_5250 STRIKETHROUGH(class_5250 text, String option) {
        return text.method_27696(class_2583.field_24360.method_36140(Boolean.valueOf(true)));
    }
}

