/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.styling;

import com.hanhy06.embellish_chat.config.Config;
import com.hanhy06.embellish_chat.config.ConfigListener;
import com.hanhy06.embellish_chat.mention.MentionTarget;
import com.hanhy06.embellish_chat.styling.StyleRegistry;
import com.hanhy06.embellish_chat.styling.StyleType;
import com.hanhy06.embellish_chat.styling.StylingRule;
import com.hanhy06.embellish_chat.styling.util.Runs;
import com.hanhy06.embellish_chat.styling.util.TextSliceUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class StylingProcessor
implements ConfigListener {
    public static StylingProcessor INSTANCE;
    private HashMap<String, List<StylingRule>> stylingRules;
    private EnumMap<StyleType, BiFunction<class_5250, String, class_5250>> registers;

    public StylingProcessor() {
        INSTANCE = this;
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.stylingRules = newConfig.stylingRules();
        StyleRegistry registry = new StyleRegistry(newConfig);
        Map.Entry[] entryArray = new Map.Entry[12];
        entryArray[0] = Map.entry(StyleType.METADATA, registry::METADATA);
        entryArray[1] = Map.entry(StyleType.COLOR_HEX, registry::COLOR_HEX);
        entryArray[2] = Map.entry(StyleType.COLOR_RAINBOW, registry::COLOR_RAINBOW);
        entryArray[3] = Map.entry(StyleType.COLOR_PRESET, registry::COLOR_PRESET);
        entryArray[4] = Map.entry(StyleType.COLOR_SHADOW, registry::COLOR_SHADOW);
        entryArray[5] = Map.entry(StyleType.FONT, registry::FONT);
        entryArray[6] = Map.entry(StyleType.URL, registry::URL);
        entryArray[7] = Map.entry(StyleType.BOLD, registry::BOLD);
        entryArray[8] = Map.entry(StyleType.ITALIC, registry::ITALIC);
        entryArray[9] = Map.entry(StyleType.UNDERLINE, registry::UNDERLINE);
        entryArray[10] = Map.entry(StyleType.STRIKETHROUGH, registry::STRIKETHROUGH);
        entryArray[11] = Map.entry(StyleType.OBFUSCATED, registry::OBFUSCATED);
        this.registers = new EnumMap(Map.ofEntries(entryArray));
    }

    public class_5250 applyStyles(class_5250 text, String key) {
        if (text.getString().isBlank()) {
            return text;
        }
        class_5250 result = text;
        for (StylingRule style : this.stylingRules.get(key)) {
            result = this.applyStyle(style, result);
        }
        return result;
    }

    public class_5250 applyMention(class_5250 text, List<MentionTarget> targets) {
        return StyleRegistry.MENTION(text, targets);
    }

    private class_5250 applyStyle(StylingRule style, class_5250 text) {
        Runs runs = TextSliceUtil.flatten((class_2561)text);
        class_5250 result = class_2561.method_43473();
        BiFunction<class_5250, String, class_5250> function = this.registers.get((Object)style.styleType());
        Matcher matcher = style.pattern().matcher(runs.full());
        if (!matcher.find()) {
            return text;
        }
        int lastEnd = 0;
        do {
            result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, matcher.start()));
            class_5250 segment = TextSliceUtil.slice(runs, matcher.start(1), matcher.end(1));
            String option = style.option();
            if (option.isBlank()) {
                option = matcher.group(2);
            }
            segment = function.apply(segment, option);
            result.method_10852((class_2561)segment);
            lastEnd = matcher.end();
        } while (matcher.find());
        result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, runs.full().length()));
        return result;
    }
}

