/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellish_chat.message;

import io.github.hanhy06.embellish_chat.config.Config;
import io.github.hanhy06.embellish_chat.config.ConfigListener;
import io.github.hanhy06.embellish_chat.mention.MentionProcessor;
import io.github.hanhy06.embellish_chat.mention.data.Mention;
import io.github.hanhy06.embellish_chat.mention.data.ParsedMention;
import io.github.hanhy06.embellish_chat.mention.data.ParsedTarget;
import io.github.hanhy06.embellish_chat.styling.StylingProcessor;
import io.github.hanhy06.embellish_chat.util.LuckPermsUtil;
import io.github.hanhy06.embellish_chat.util.PermissionUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_7471;

public class MessageProcessor
implements ConfigListener {
    public static MessageProcessor INSTANCE;
    private final MentionProcessor mentionProcessor;
    private final StylingProcessor stylingManager;
    private final class_3324 playerManager;
    private Config config;
    private List<UUID> bannedPlayerList;

    public MessageProcessor(MentionProcessor mentionProcessor, StylingProcessor stylingManager, class_3324 playerManager) {
        INSTANCE = this;
        this.mentionProcessor = mentionProcessor;
        this.stylingManager = stylingManager;
        this.playerManager = playerManager;
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.config = newConfig;
        this.bannedPlayerList = this.config.bannedPlayerList();
    }

    public class_7471 handleMessage(class_7471 message) {
        if (this.bannedPlayerList.contains(message.method_46292())) {
            return message;
        }
        class_3222 sender = this.playerManager.method_14602(message.method_46292());
        class_5250 textMessage = message.method_46291().method_27661();
        String stringMessage = message.method_46291().getString();
        List<Mention> mentions = this.handleMention(sender, stringMessage);
        textMessage = this.stylingManager.applyMention(textMessage, mentions);
        for (String key : PermissionUtil.getPermissions(sender, this.config.stylingRules().keySet())) {
            textMessage = this.stylingManager.applyStylingRule(textMessage, key);
        }
        return message.method_44863((class_2561)textMessage);
    }

    private List<Mention> handleMention(class_3222 sender, String message) {
        ArrayList<Mention> mentions = new ArrayList<Mention>();
        if (sender == null || message.isBlank()) {
            return mentions;
        }
        List<String> keys = PermissionUtil.getPermissions(sender, this.config.mentionRules().keySet());
        HashSet<ParsedMention> parsedMentions = new HashSet<ParsedMention>();
        for (String key : keys) {
            parsedMentions.addAll(this.mentionProcessor.parseMentions(message, key));
        }
        List<ParsedTarget> parsedTargets = this.mentionProcessor.parseTargets(sender, parsedMentions);
        HashSet<class_3222> targets = new HashSet<class_3222>();
        parsedTargets.forEach(target -> targets.addAll(target.players()));
        if (!targets.isEmpty()) {
            if (FabricLoader.getInstance().isModLoaded("luckperms")) {
                this.mentionProcessor.broadcastMentions(sender, targets.stream().filter(LuckPermsUtil::getNotification).collect(Collectors.toSet()));
            } else {
                this.mentionProcessor.broadcastMentions(sender, targets);
            }
        }
        parsedTargets.forEach(target -> mentions.add(target.createMention()));
        mentions.sort(Comparator.comparing(Mention::begin));
        return mentions;
    }
}

