/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellish_chat.util;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.hanhy06.embellish_chat.EmbellishChat;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternTypeAdapter
extends TypeAdapter<Pattern> {
    public void write(JsonWriter out, Pattern value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(value.pattern());
    }

    public Pattern read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        if (token == JsonToken.NULL) {
            in.nextNull();
            throw new JsonSyntaxException("Cannot parse JSON null as a pattern pattern.");
        }
        if (token != JsonToken.STRING) {
            throw new JsonSyntaxException("Expected a string for a pattern pattern, but found " + String.valueOf(token) + ".");
        }
        String regex = in.nextString();
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            EmbellishChat.LOGGER.error("Failed to compile regex pattern from config: \"{}\"", (Object)regex, (Object)e);
            throw new JsonSyntaxException("Invalid pattern pattern: \"" + regex + "\"", (Throwable)e);
        }
    }
}

