/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.mention;

import io.github.hanhy06.embellishchat.config.Config;
import io.github.hanhy06.embellishchat.config.ConfigListener;
import io.github.hanhy06.embellishchat.mention.data.MentionTarget;
import io.github.hanhy06.embellishchat.mention.data.ParsedMention;
import io.github.hanhy06.embellishchat.mention.data.ParsedTarget;
import io.github.hanhy06.embellishchat.mention.rule.MentionAction;
import io.github.hanhy06.embellishchat.mention.rule.MentionParameter;
import io.github.hanhy06.embellishchat.mention.rule.MentionRegistry;
import io.github.hanhy06.embellishchat.mention.rule.MentionRule;
import io.github.hanhy06.embellishchat.util.OptionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import net.minecraft.class_2583;
import net.minecraft.class_269;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3419;

public class MentionProcessor
implements ConfigListener {
    private final class_3324 manager;
    private final class_269 scoreboard;
    private Config config;
    private Map<String, List<MentionRule>> mentionRules;
    private MentionRegistry registries;

    public MentionProcessor(class_3324 manager, class_269 scoreboard) {
        this.manager = manager;
        this.scoreboard = scoreboard;
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.config = newConfig;
        this.mentionRules = this.config.mentionRules();
        this.registries = new MentionRegistry(newConfig, this.manager, this.scoreboard);
    }

    public Set<ParsedMention> parseMentions(String message, String key) {
        HashSet<ParsedMention> parsedMentions = new HashSet<ParsedMention>();
        if (!this.mentionRules.containsKey(key)) {
            return parsedMentions;
        }
        List<MentionRule> rules = this.mentionRules.get(key);
        for (MentionRule rule : rules) {
            parsedMentions.addAll(this.parseMention(rule, message));
        }
        return parsedMentions;
    }

    private List<ParsedMention> parseMention(MentionRule rule, String message) {
        Matcher matcher = rule.pattern().matcher(message);
        ArrayList<ParsedMention> parsedMentions = new ArrayList<ParsedMention>();
        while (matcher.find()) {
            List<String> mentions = OptionUtil.split(matcher.group(1), this.config.delimiter());
            parsedMentions.add(ParsedMention.of(rule, mentions, matcher.start(), matcher.end()));
        }
        return parsedMentions;
    }

    public List<ParsedTarget> parseTargets(class_3222 sender, Set<ParsedMention> parsedMentions) {
        ArrayList<ParsedTarget> parsedTargets = new ArrayList<ParsedTarget>();
        for (ParsedMention mention : parsedMentions) {
            ParsedTarget target = this.parseTarget(sender, mention);
            parsedTargets.add(target);
        }
        return parsedTargets;
    }

    private ParsedTarget parseTarget(class_3222 sender, ParsedMention mention) {
        ArrayList<ParsedTarget> targets = new ArrayList<ParsedTarget>();
        List<MentionAction> actions = mention.rule().mentions();
        List<String> mentions = mention.mentions();
        for (int i = 0; i < actions.size(); ++i) {
            MentionAction action = actions.get(i);
            String option = OptionUtil.parseOption(i < mentions.size() ? mentions.get(i) : "", action.preset(), sender);
            ParsedTarget target = this.registries.get(action.mentionType()).apply(MentionParameter.of(mention, sender, option));
            targets.add(target);
        }
        if (targets.isEmpty()) {
            return new ParsedTarget(mention, List.of(), class_2583.field_24360);
        }
        ParsedTarget first = (ParsedTarget)targets.getFirst();
        for (int i = 1; i < targets.size(); ++i) {
            first.targets().retainAll(((ParsedTarget)targets.get(i)).targets());
            if (first.targets().isEmpty()) break;
        }
        return first;
    }

    public void broadcastMentions(Set<MentionTarget> targets) {
        for (MentionTarget target : targets) {
            target.player().method_7353(target.title(), true);
            target.player().method_17356(target.sound(), class_3419.field_61058, 1.0f, target.pitch());
        }
    }
}

