/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.chat.processor;

import com.hanhy06.embellish_chat.EmbellishChat;
import com.hanhy06.embellish_chat.data.Config;
import com.hanhy06.embellish_chat.data.Receiver;
import com.hanhy06.embellish_chat.util.Metadata;
import java.awt.Color;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class StyledTextProcessor {
    private static final Pattern BOLD = Pattern.compile("(?<!\\\\)\\*\\*(.+?)\\*\\*");
    private static final Pattern UNDERLINE = Pattern.compile("(?<!\\\\)__(.+?)__");
    private static final Pattern ITALIC = Pattern.compile("(?<!\\\\)(?<!_)_([^_]+?)_(?!_)");
    private static final Pattern STRIKETHROUGH = Pattern.compile("(?<!\\\\)~~(.+?)~~");
    private static final Pattern OBFUSCATED = Pattern.compile("(?<!\\\\)\\|\\|(.+?)\\|\\|");
    private static final Pattern COLOR = Pattern.compile("(?<!\\\\)\\[(.+?)]<([^>]+?)>");
    private static final Pattern OPEN_URI = Pattern.compile("(?<![\\\\!])\\[(.+?)]\\((https://[^\\s)]+?)\\)");
    private static final Pattern FONT = Pattern.compile("(?<!\\\\)\\[(.+?)]\\{([^}]+?)}");
    private static final int URL_COLOR = 238;
    private Config config = null;
    private int defaultChatColor = 0;
    private class_2960 defaultChatFont = null;
    private HashMap<String, Integer> defaultColorPreset = null;

    public void updateConfig(Config config) {
        this.config = config;
        this.defaultChatColor = config.defaultChatColor();
        this.defaultColorPreset = config.defaultColorPreset();
        this.defaultChatFont = !config.defaultChatFont().isEmpty() ? class_2960.method_12829((String)config.defaultChatFont()) : null;
    }

    public class_5250 applyStyles(class_5250 text, List<Receiver> receivers) {
        if (text == null || text.getString().isBlank()) {
            return text;
        }
        class_5250 result = text;
        result = this.applyDefaultColor(result);
        result = this.applyDefaultFont(result);
        if (receivers != null && !receivers.isEmpty()) {
            result = this.applyMention(result, receivers);
        }
        if (this.config.markdownEnabled()) {
            result = this.applyMarkdown(result);
        }
        if (this.config.fontEnabled()) {
            result = this.applyPattern(FONT, result, this::applyFont);
        }
        if (this.config.openUriEnabled()) {
            result = this.applyPattern(OPEN_URI, result, this::applyOpenURI);
        }
        if (this.config.coloringEnabled()) {
            result = this.applyPattern(COLOR, result, this::applyColor);
        }
        result = StyledTextProcessor.removeEscapeSlashes(result);
        return Metadata.metadata(result);
    }

    private class_5250 applyDefaultColor(class_5250 text) {
        if (this.defaultChatColor > 0) {
            return text.method_27696(class_2583.field_24360.method_36139(this.defaultChatColor));
        }
        if (this.defaultChatColor < 0) {
            return this.applyRainbow(text);
        }
        return text;
    }

    private class_5250 applyDefaultFont(class_5250 text) {
        if (this.defaultChatFont != null) {
            return text.method_27696(class_2583.field_24360.method_27704(this.defaultChatFont));
        }
        return text;
    }

    private class_5250 applyMarkdown(class_5250 text) {
        class_5250 result = text;
        result = this.applyPattern(BOLD, result, class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        result = this.applyPattern(UNDERLINE, result, class_2583.field_24360.method_30938(Boolean.valueOf(true)));
        result = this.applyPattern(ITALIC, result, class_2583.field_24360.method_10978(Boolean.valueOf(true)));
        result = this.applyPattern(STRIKETHROUGH, result, class_2583.field_24360.method_36140(Boolean.valueOf(true)));
        result = this.applyPattern(OBFUSCATED, result, class_2583.field_24360.method_36141(Boolean.valueOf(true)));
        return result;
    }

    private class_5250 applyPattern(Pattern pattern, class_5250 text, class_2583 style) {
        String str = text.getString();
        Matcher matcher = pattern.matcher(str);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        matcher.reset();
        while (matcher.find()) {
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, matcher.start()));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, matcher.start(1), matcher.end(1)).method_27696(style));
            lastEnd = matcher.end();
        }
        result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, str.length()));
        return result;
    }

    private class_5250 applyPattern(Pattern pattern, class_5250 text, BiFunction<class_5250, String, class_5250> function) {
        String str = text.getString();
        Matcher matcher = pattern.matcher(str);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        matcher.reset();
        while (matcher.find()) {
            class_5250 styledText = function.apply(StyledTextProcessor.substring((class_2561)text, matcher.start(1), matcher.end(1)), matcher.group(2));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, matcher.start()));
            result.method_10852((class_2561)styledText);
            lastEnd = matcher.end();
        }
        result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, str.length()));
        return result;
    }

    private class_5250 applyColor(class_5250 text, String strColor) {
        boolean inPreset = this.defaultColorPreset.containsKey(strColor);
        if (inPreset) {
            int color = this.defaultColorPreset.getOrDefault(strColor, this.defaultChatColor);
            return text.method_27696(class_2583.field_24360.method_36139(color));
        }
        if (strColor.charAt(0) == '#') {
            int color = Color.decode(strColor).getRGB();
            return text.method_27696(class_2583.field_24360.method_36139(color));
        }
        if (strColor.equals("rainbow") && this.config.rainbowEnabled()) {
            return this.applyRainbow(text);
        }
        return text;
    }

    private class_5250 applyFont(class_5250 text, String strFont) {
        return text.method_27696(class_2583.field_24360.method_27704(class_2960.method_12829((String)strFont)));
    }

    private class_5250 applyOpenURI(class_5250 text, String strUri) {
        try {
            URI uri = URI.create(strUri);
            class_2558.class_10608 clickEvent = new class_2558.class_10608(uri);
            return text.method_27696(class_2583.field_24360.method_10958((class_2558)clickEvent).method_36139(238));
        }
        catch (IllegalArgumentException e) {
            EmbellishChat.LOGGER.warn("Invalid URL address: {}", (Object)strUri);
            return text;
        }
    }

    private class_5250 applyRainbow(class_5250 text) {
        class_5250 result = class_2561.method_43473();
        int length = text.getString().length();
        for (int i = 0; i < length; ++i) {
            float hue = (float)i / (float)length;
            int rgb = Color.HSBtoRGB(hue, 0.7f, 1.0f);
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, i, i + 1).method_27696(class_2583.field_24360.method_36139(rgb)));
        }
        return result;
    }

    private class_5250 applyMention(class_5250 text, List<Receiver> receivers) {
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        for (Receiver receiver : receivers) {
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, receiver.begin()));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, receiver.begin(), receiver.end()).method_27696(class_2583.field_24360.method_36139(receiver.teamColor()).method_10982(Boolean.valueOf(true))));
            lastEnd = receiver.end();
        }
        result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, text.getString().length()));
        return result;
    }

    private static class_5250 removeEscapeSlashes(class_5250 text) {
        final class_5250 result = class_2561.method_43473();
        final int[] offset = new int[]{0};
        text.method_27658((class_5348.class_5246)new class_5348.class_5246<Void>(){

            public Optional<Void> accept(class_2583 style, String content) {
                String replaced = content.replaceAll("\\\\([*_~#\\\\])", "$1");
                result.method_10852((class_2561)class_2561.method_43470((String)replaced).method_10862(style));
                offset[0] = offset[0] + content.length();
                return Optional.empty();
            }
        }, class_2583.field_24360);
        return result;
    }

    private static class_5250 substring(class_2561 text, final int beginIndex, final int endIndex) {
        if (beginIndex >= endIndex || text == null) {
            return class_2561.method_43473();
        }
        final class_5250 result = class_2561.method_43473();
        final int[] currentCharacterOffset = new int[]{0};
        text.method_27658((class_5348.class_5246)new class_5348.class_5246<Void>(){

            public Optional<Void> accept(class_2583 style, String content) {
                int effectiveEndIndexInFullText;
                int contentStartOffset = currentCharacterOffset[0];
                int contentEndOffset = contentStartOffset + content.length();
                int effectiveStartIndexInFullText = Math.max(contentStartOffset, beginIndex);
                if (effectiveStartIndexInFullText < (effectiveEndIndexInFullText = Math.min(contentEndOffset, endIndex))) {
                    int subStartIndexInContentPiece = effectiveStartIndexInFullText - contentStartOffset;
                    int subEndIndexInContentPiece = effectiveEndIndexInFullText - contentStartOffset;
                    String subContent = content.substring(subStartIndexInContentPiece, subEndIndexInContentPiece);
                    result.method_10852((class_2561)class_2561.method_43470((String)subContent).method_10862(style));
                }
                currentCharacterOffset[0] = contentEndOffset;
                return Optional.empty();
            }
        }, class_2583.field_24360);
        return result;
    }
}

