/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.chat.processor;

import com.hanhy06.embellish_chat.data.Config;
import com.hanhy06.embellish_chat.data.Receiver;
import com.hanhy06.embellish_chat.util.TeamColor;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class Mention {
    private static final Pattern MENTION_PATTERN = Pattern.compile("@([A-Za-z0-9_]{1,16})(?=\\b|$)");

    public static void broadcastMention(Config config, class_6880<class_3414> mentionSound, class_3222 sender, List<Receiver> receivers) {
        class_3324 manager = sender.method_5682().method_3760();
        for (Receiver receiver : new HashSet<Receiver>(receivers)) {
            UUID uuid = receiver.profile().getId();
            class_3222 player = manager.method_14602(uuid);
            int teamColor = TeamColor.getPlayerColor(sender);
            class_5250 titleText = sender.method_5477().method_27661().method_27694(style -> style.method_36139(teamColor == -1 ? config.defaultMentionColor() : teamColor).method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)" mentioned you").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1068)));
            if (player == null) continue;
            player.field_13987.method_14364((class_2596)new class_2767(mentionSound, class_3419.field_15250, player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.75f, 1L));
            player.method_7353((class_2561)titleText, true);
        }
    }

    public static List<Receiver> mentionParser(MinecraftServer server, String originalMessage) {
        ArrayList<Receiver> receivers = new ArrayList<Receiver>();
        if (originalMessage == null || !originalMessage.contains("@")) {
            return receivers;
        }
        class_3312 userCache = server.method_3793();
        class_3324 playerManager = server.method_3760();
        for (Unit unit : Mention.nameParser(originalMessage)) {
            Optional profile = userCache.method_14515(unit.name);
            if (profile.isEmpty()) continue;
            int teamColor = TeamColor.decideTeamColor(playerManager, server, ((GameProfile)profile.get()).getId(), ((GameProfile)profile.get()).getName());
            receivers.add(new Receiver((GameProfile)profile.get(), unit.begin, unit.end, teamColor));
        }
        return receivers;
    }

    private static List<Unit> nameParser(String raw) {
        ArrayList<Unit> unit = new ArrayList<Unit>();
        Matcher matcher = MENTION_PATTERN.matcher(raw);
        while (matcher.find()) {
            unit.add(new Unit(matcher.group(1), matcher.start(), matcher.end(1)));
        }
        return unit;
    }

    private record Unit(String name, int begin, int end) {
    }
}

