/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.chat.processor;

import com.hanhy06.embellish_chat.data.Config;
import com.hanhy06.embellish_chat.data.Receiver;
import com.hanhy06.embellish_chat.util.TeamColor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5250;

public class Mention {
    private static final Pattern MENTION_PATTERN = Pattern.compile("@([A-Za-z0-9_]{1,16})(?=\\b|$)");
    private final class_3324 manager;
    private final class_269 scoreboard;
    private class_3414 mentionSound;
    private float mentionPitch;
    private String mentionMessage;
    private boolean offlineColorEnabled;
    private int defaultMentionColor;

    public Mention(class_3324 manager, class_269 scoreboard) {
        this.manager = manager;
        this.scoreboard = scoreboard;
    }

    public void updateConfig(Config config) {
        this.mentionSound = class_3414.method_47908((class_2960)class_2960.method_12829((String)config.defaultMentionSound()));
        this.mentionPitch = config.defaultMentionPitch();
        this.mentionMessage = config.defaultMentionMessage();
        this.offlineColorEnabled = config.offlineColorEnabled();
        this.defaultMentionColor = config.defaultMentionColor();
    }

    public void broadcastMention(class_3222 sender, List<Receiver> receivers) {
        class_5250 titleText = sender.method_5477().method_27661();
        titleText.method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_36139(TeamColor.getPlayerColor(sender)));
        titleText.method_10852((class_2561)class_2561.method_43470((String)this.mentionMessage).method_27694(style -> style.method_10982(Boolean.valueOf(false)).method_36139(0xFFFFFF)));
        for (Receiver receiver : new HashSet<Receiver>(receivers)) {
            class_3222 player = receiver.player();
            if (player == null) continue;
            player.method_17356(this.mentionSound, class_3419.field_61058, 1.0f, this.mentionPitch);
            player.method_7353((class_2561)titleText, true);
        }
    }

    public List<Receiver> parseMentions(String raw) {
        ArrayList<Receiver> receivers = new ArrayList<Receiver>();
        Matcher matcher = MENTION_PATTERN.matcher(raw);
        while (matcher.find()) {
            String name = matcher.group(1);
            class_3222 player = this.manager.method_14566(name);
            int teamColor = player != null ? TeamColor.getPlayerColor(player) : (this.offlineColorEnabled ? TeamColor.getPlayerColor(this.scoreboard, name) : this.defaultMentionColor);
            receivers.add(new Receiver(name, matcher.start(), matcher.end(1), teamColor, player));
        }
        return receivers;
    }
}

