/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.chat.processor;

import com.hanhy06.embellish_chat.data.Config;
import com.hanhy06.embellish_chat.data.Receiver;
import com.hanhy06.embellish_chat.data.Target;
import com.hanhy06.embellish_chat.util.TeamColor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5250;

public class Mention {
    private static final Pattern MENTION_PATTERN = Pattern.compile("@([A-Za-z0-9_]{1,16})(?=\\b|$)");
    private final class_3324 manager;
    private final class_269 scoreboard;
    private boolean groupMentionOpOnly;
    private boolean offlineColorEnabled;
    private int mentionColor;
    private int groupMentionColor;
    private class_3414 mentionSound;
    private float mentionPitch;
    private String mentionTitlePrefix;
    private String mentionTitleSuffix;
    private double hereRadius;

    public Mention(class_3324 manager, class_269 scoreboard) {
        this.manager = manager;
        this.scoreboard = scoreboard;
    }

    public void updateConfig(Config config) {
        this.groupMentionOpOnly = config.groupMentionOpOnly();
        this.offlineColorEnabled = config.offlineColorEnabled();
        this.mentionColor = config.mentionColor();
        this.groupMentionColor = config.groupMentionColor();
        this.mentionSound = class_3414.method_47908((class_2960)class_2960.method_12829((String)config.mentionSound()));
        this.mentionPitch = config.mentionPitch();
        this.mentionTitlePrefix = config.mentionTitlePrefix();
        this.mentionTitleSuffix = config.mentionTitleSuffix();
        this.hereRadius = config.hereRadius();
    }

    public void broadcastMention(class_3222 sender, List<Receiver> receivers) {
        class_5250 titleText = class_2561.method_43473();
        titleText.method_10852((class_2561)class_2561.method_43470((String)this.mentionTitlePrefix).method_27694(style -> style.method_10982(Boolean.valueOf(false)).method_36139(0xFFFFFF)));
        titleText.method_10852((class_2561)sender.method_5477().method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_36139(TeamColor.getPlayerColor(sender))));
        titleText.method_10852((class_2561)class_2561.method_43470((String)this.mentionTitleSuffix).method_27694(style -> style.method_10982(Boolean.valueOf(false)).method_36139(0xFFFFFF)));
        for (Receiver receiver : receivers) {
            if (receiver.players() == null || receiver.players().isEmpty()) continue;
            for (class_3222 player : receiver.players()) {
                player.method_17356(this.mentionSound, class_3419.field_61058, 1.0f, this.mentionPitch);
                player.method_7353((class_2561)titleText, true);
            }
        }
    }

    public List<Target> parseMentions(String raw) {
        Matcher matcher = MENTION_PATTERN.matcher(raw);
        ArrayList<Target> targets = new ArrayList<Target>();
        while (matcher.find()) {
            targets.add(new Target(matcher.group(1), matcher.start(), matcher.end(1)));
        }
        return targets;
    }

    public List<Receiver> processReceiver(class_3222 sender, List<Target> targets) {
        ArrayList<Receiver> receivers = new ArrayList<Receiver>();
        boolean canGroupMention = this.canUseGroupMention(sender);
        for (Target target : targets) {
            String name = target.name();
            if (canGroupMention) {
                switch (name) {
                    case "everyone": {
                        receivers.add(this.targetEveryone(target));
                        break;
                    }
                    case "here": {
                        receivers.add(this.targetHere(sender, target));
                        break;
                    }
                    case "team": {
                        receivers.add(this.targetTeam(sender, target));
                        break;
                    }
                    default: {
                        receivers.add(this.targetPlayer(target));
                        break;
                    }
                }
                continue;
            }
            receivers.add(this.targetPlayer(target));
        }
        return receivers;
    }

    private Receiver targetEveryone(Target target) {
        return new Receiver("everyone", target.begin(), target.end(), this.groupMentionColor, this.manager.method_14571());
    }

    private Receiver targetHere(class_3222 sender, Target target) {
        List<class_3222> players = PlayerLookup.around((class_3218)sender.method_51469(), (class_243)sender.method_73189(), (double)this.hereRadius).stream().toList();
        return new Receiver("here", target.begin(), target.end(), this.groupMentionColor, players);
    }

    private Receiver targetTeam(class_3222 sender, Target target) {
        class_268 team = sender.method_5781();
        if (team != null) {
            int color = this.groupMentionColor;
            class_124 formatting = team.method_1202();
            if (formatting != null && formatting.method_543() && formatting != class_124.field_1070) {
                color = formatting.method_532();
            }
            List<class_3222> players = team.method_1204().stream().map(arg_0 -> ((class_3324)this.manager).method_14566(arg_0)).filter(Objects::nonNull).toList();
            return new Receiver("team", target.begin(), target.end(), color, players);
        }
        return new Receiver("team", target.begin(), target.end(), this.groupMentionColor, null);
    }

    private Receiver targetPlayer(Target target) {
        class_3222 player = this.manager.method_14566(target.name());
        int teamColor = player != null ? TeamColor.getPlayerColor(player) : (this.offlineColorEnabled ? TeamColor.getPlayerColor(this.scoreboard, target.name()) : this.mentionColor);
        return new Receiver(target.name(), target.begin(), target.end(), teamColor, player != null ? List.of(player) : null);
    }

    private boolean canUseGroupMention(class_3222 player) {
        return !this.groupMentionOpOnly || this.manager.method_14569(player.method_72498());
    }
}

