/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.chat.processor;

import com.hanhy06.embellish_chat.EmbellishChat;
import com.hanhy06.embellish_chat.data.Config;
import com.hanhy06.embellish_chat.data.Receiver;
import com.hanhy06.embellish_chat.util.Metadata;
import java.awt.Color;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_11719;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class StyledTextProcessor {
    private static final Pattern BOLD = Pattern.compile("(?<!\\\\)\\*\\*(.+?)\\*\\*");
    private static final Pattern UNDERLINE = Pattern.compile("(?<!\\\\)__(.+?)__");
    private static final Pattern ITALIC = Pattern.compile("(?<!\\\\)(?<!_)_([^_]+?)_(?!_)");
    private static final Pattern STRIKETHROUGH = Pattern.compile("(?<!\\\\)~~(.+?)~~");
    private static final Pattern OBFUSCATED = Pattern.compile("(?<!\\\\)\\|\\|(.+?)\\|\\|");
    private static final Pattern COLOR = Pattern.compile("(?<!\\\\)\\[(.+?)]<([^>]+?)>");
    private static final Pattern OPEN_URI = Pattern.compile("(?<![\\\\!])\\[(.+?)]\\((https://[^\\s)]+?)\\)");
    private static final Pattern FONT = Pattern.compile("(?<!\\\\)\\[(.+?)]\\{([^}]+?)}");
    private static final Pattern ESCAPES = Pattern.compile("\\\\([*_~#\\\\])");
    private static final int URL_COLOR = 238;
    private boolean fontEnabled;
    private boolean coloringEnabled;
    private boolean rainbowEnabled;
    private boolean openUriEnabled;
    private boolean markdownEnabled;
    private boolean metadataEnabled;
    private HashMap<String, Integer> colorPreset;
    private int chatColor;
    private class_11719 chatFont;

    public void updateConfig(Config config) {
        this.fontEnabled = config.fontEnabled();
        this.coloringEnabled = config.coloringEnabled();
        this.rainbowEnabled = config.rainbowEnabled();
        this.openUriEnabled = config.openUriEnabled();
        this.markdownEnabled = config.markdownEnabled();
        this.metadataEnabled = config.metadataEnabled();
        this.colorPreset = config.colorPreset();
        this.chatColor = config.chatColor();
        this.chatFont = !config.chatFont().isEmpty() ? new class_11719.class_11721(class_2960.method_12829((String)config.chatFont())) : null;
    }

    public class_5250 applyStyles(class_5250 text, List<Receiver> receivers) {
        if (text == null || text.getString().isBlank()) {
            return text;
        }
        class_5250 result = text;
        result = this.applyDefaultColor(result);
        result = this.applyDefaultFont(result);
        if (receivers != null && !receivers.isEmpty()) {
            result = this.applyMention(result, receivers);
        }
        if (this.markdownEnabled) {
            result = this.applyMarkdown(result);
        }
        if (this.fontEnabled) {
            result = this.applyPattern(FONT, result, this::applyFont);
        }
        if (this.openUriEnabled) {
            result = this.applyPattern(OPEN_URI, result, this::applyOpenURI);
        }
        if (this.coloringEnabled) {
            result = this.applyPattern(COLOR, result, this::applyColor);
        }
        if (this.metadataEnabled) {
            result = Metadata.metadata(result);
        }
        result = StyledTextProcessor.removeEscapeSlashes(result);
        return result;
    }

    private class_5250 applyDefaultColor(class_5250 text) {
        if (this.chatColor > 0) {
            return text.method_27696(class_2583.field_24360.method_36139(this.chatColor));
        }
        if (this.chatColor < 0) {
            return this.applyRainbow(text);
        }
        return text;
    }

    private class_5250 applyDefaultFont(class_5250 text) {
        if (this.chatFont != null) {
            return text.method_27696(class_2583.field_24360.method_27704(this.chatFont));
        }
        return text;
    }

    private class_5250 applyMarkdown(class_5250 text) {
        class_5250 result = text;
        result = this.applyPattern(BOLD, result, class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        result = this.applyPattern(UNDERLINE, result, class_2583.field_24360.method_30938(Boolean.valueOf(true)));
        result = this.applyPattern(ITALIC, result, class_2583.field_24360.method_10978(Boolean.valueOf(true)));
        result = this.applyPattern(STRIKETHROUGH, result, class_2583.field_24360.method_36140(Boolean.valueOf(true)));
        result = this.applyPattern(OBFUSCATED, result, class_2583.field_24360.method_36141(Boolean.valueOf(true)));
        return result;
    }

    private class_5250 applyPattern(Pattern pattern, class_5250 text, class_2583 style) {
        Runs runs = StyledTextProcessor.flatten((class_2561)text);
        Matcher matcher = pattern.matcher(runs.full());
        if (!matcher.find()) {
            return text;
        }
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        do {
            result.method_10852((class_2561)StyledTextProcessor.slice(runs, lastEnd, matcher.start()));
            result.method_10852((class_2561)StyledTextProcessor.slice(runs, matcher.start(1), matcher.end(1)).method_27696(style));
            lastEnd = matcher.end();
        } while (matcher.find());
        result.method_10852((class_2561)StyledTextProcessor.slice(runs, lastEnd, runs.full().length()));
        return result;
    }

    private class_5250 applyPattern(Pattern pattern, class_5250 text, BiFunction<class_5250, String, class_5250> function) {
        Runs runs = StyledTextProcessor.flatten((class_2561)text);
        Matcher matcher = pattern.matcher(runs.full());
        if (!matcher.find()) {
            return text;
        }
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        do {
            result.method_10852((class_2561)StyledTextProcessor.slice(runs, lastEnd, matcher.start()));
            result.method_10852((class_2561)function.apply(StyledTextProcessor.slice(runs, matcher.start(1), matcher.end(1)), matcher.group(2)));
            lastEnd = matcher.end();
        } while (matcher.find());
        result.method_10852((class_2561)StyledTextProcessor.slice(runs, lastEnd, runs.full().length()));
        return result;
    }

    private class_5250 applyColor(class_5250 text, String strColor) {
        Integer preset = this.colorPreset.get(strColor);
        if (preset != null) {
            return text.method_27696(class_2583.field_24360.method_36139(preset.intValue()));
        }
        if (!strColor.isEmpty() && strColor.charAt(0) == '#') {
            int color = Color.decode(strColor).getRGB();
            return text.method_27696(class_2583.field_24360.method_36139(color));
        }
        if (strColor.equals("rainbow") && this.rainbowEnabled) {
            return this.applyRainbow(text);
        }
        return text;
    }

    private class_5250 applyFont(class_5250 text, String strFont) {
        return text.method_27696(class_2583.field_24360.method_27704((class_11719)new class_11719.class_11721(class_2960.method_12829((String)strFont))));
    }

    private class_5250 applyOpenURI(class_5250 text, String strUri) {
        try {
            URI uri = URI.create(strUri);
            class_2558.class_10608 clickEvent = new class_2558.class_10608(uri);
            return text.method_27696(class_2583.field_24360.method_10958((class_2558)clickEvent).method_36139(238));
        }
        catch (IllegalArgumentException e) {
            EmbellishChat.LOGGER.warn("Invalid URL address: {}", (Object)strUri);
            return text;
        }
    }

    private class_5250 applyRainbow(class_5250 text) {
        Runs runs = StyledTextProcessor.flatten((class_2561)text);
        String string = runs.full();
        int length = string.length();
        if (length == 0) {
            return text;
        }
        class_5250 out = class_2561.method_43473();
        for (int i = 0; i < length; ++i) {
            float hue = (float)i / (float)length;
            int rgb = Color.HSBtoRGB(hue, 0.7f, 1.0f);
            out.method_10852((class_2561)StyledTextProcessor.slice(runs, i, i + 1).method_27696(class_2583.field_24360.method_36139(rgb)));
        }
        return out;
    }

    private class_5250 applyMention(class_5250 text, List<Receiver> receivers) {
        Runs runs = StyledTextProcessor.flatten((class_2561)text);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        for (Receiver receiver : receivers) {
            result.method_10852((class_2561)StyledTextProcessor.slice(runs, lastEnd, receiver.begin()));
            result.method_10852((class_2561)StyledTextProcessor.slice(runs, receiver.begin(), receiver.end()).method_27696(class_2583.field_24360.method_36139(receiver.teamColor()).method_10982(Boolean.valueOf(true))));
            lastEnd = receiver.end();
        }
        result.method_10852((class_2561)StyledTextProcessor.slice(runs, lastEnd, runs.full().length()));
        return result;
    }

    private static class_5250 removeEscapeSlashes(class_5250 text) {
        Runs runs = StyledTextProcessor.flatten((class_2561)text);
        class_5250 result = class_2561.method_43473();
        for (Run run : runs.runs()) {
            String content = run.content();
            if (content.indexOf(92) < 0) {
                result.method_10852((class_2561)class_2561.method_43470((String)content).method_10862(run.style()));
                continue;
            }
            String replaced = ESCAPES.matcher(content).replaceAll("$1");
            result.method_10852((class_2561)class_2561.method_43470((String)replaced).method_10862(run.style()));
        }
        return result;
    }

    private static Runs flatten(class_2561 text) {
        final ArrayList<Run> list = new ArrayList<Run>();
        final StringBuilder all = new StringBuilder();
        text.method_27658((class_5348.class_5246)new class_5348.class_5246<Void>(){

            public Optional<Void> accept(class_2583 style, String content) {
                int start = all.length();
                all.append(content);
                int end = all.length();
                list.add(new Run(start, end, style, content));
                return Optional.empty();
            }
        }, class_2583.field_24360);
        return new Runs(all.toString(), list);
    }

    private static class_5250 slice(Runs runs, int begin, int end) {
        class_5250 out = class_2561.method_43473();
        for (Run run : runs.runs()) {
            if (run.end() <= begin) continue;
            if (run.start() >= end) break;
            int startIndex = Math.max(begin, run.start()) - run.start();
            int endIndex = Math.min(end, run.end()) - run.start();
            out.method_10852((class_2561)class_2561.method_43470((String)run.content().substring(startIndex, endIndex)).method_10862(run.style()));
        }
        return out;
    }

    record Runs(String full, List<Run> runs) {
    }

    record Run(int start, int end, class_2583 style, String content) {
    }
}

