/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.message;

import io.github.hanhy06.embellishchat.config.Config;
import io.github.hanhy06.embellishchat.config.ConfigListener;
import io.github.hanhy06.embellishchat.mention.MentionProcessor;
import io.github.hanhy06.embellishchat.mention.data.MentionSegment;
import io.github.hanhy06.embellishchat.mention.data.MentionTarget;
import io.github.hanhy06.embellishchat.mention.data.ParsedMention;
import io.github.hanhy06.embellishchat.mention.data.ParsedTarget;
import io.github.hanhy06.embellishchat.styling.StylingProcessor;
import io.github.hanhy06.embellishchat.util.PermissionUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_7471;

public class MessageProcessor
implements ConfigListener {
    public static MessageProcessor INSTANCE;
    private final MentionProcessor mentionProcessor;
    private final StylingProcessor stylingProcessor;
    private final class_3324 playerManager;
    private Config config;
    private Set<UUID> bannedPlayerList;
    private boolean notification;
    private boolean permission;

    public MessageProcessor(MentionProcessor mentionProcessor, StylingProcessor stylingProcessor, class_3324 playerManager) {
        INSTANCE = this;
        this.mentionProcessor = mentionProcessor;
        this.stylingProcessor = stylingProcessor;
        this.playerManager = playerManager;
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.config = newConfig;
        this.bannedPlayerList = this.config.bannedPlayerList();
        this.notification = this.config.notificationCommandEnable();
        this.permission = FabricLoader.getInstance().isModLoaded("luckperms");
    }

    public class_7471 handleMessage(class_7471 message) {
        if (this.bannedPlayerList.contains(message.method_46292())) {
            return message;
        }
        class_3222 sender = this.playerManager.method_14602(message.method_46292());
        class_5250 textMessage = message.method_46291().method_27661();
        String stringMessage = message.method_46291().getString();
        List<MentionSegment> mentionSegments = this.handleMention(sender, stringMessage);
        textMessage = this.stylingProcessor.applyMention(textMessage, mentionSegments);
        for (String key : PermissionUtil.getPermissions(sender, this.config.stylingRules().keySet())) {
            textMessage = this.stylingProcessor.applyStylingRule(textMessage, key, sender);
        }
        return message.method_44863((class_2561)textMessage);
    }

    private List<MentionSegment> handleMention(class_3222 sender, String message) {
        ArrayList<MentionSegment> mentionSegments = new ArrayList<MentionSegment>();
        if (sender == null || message.isBlank()) {
            return mentionSegments;
        }
        List<String> keys = PermissionUtil.getPermissions(sender, this.config.mentionRules().keySet());
        HashSet<ParsedMention> parsedMentions = new HashSet<ParsedMention>();
        for (String key : keys) {
            parsedMentions.addAll(this.mentionProcessor.parseMentions(message, key));
        }
        List<ParsedTarget> parsedTargets = this.mentionProcessor.parseTargets(sender, parsedMentions);
        HashSet<MentionTarget> targets = new HashSet<MentionTarget>();
        for (ParsedTarget target : parsedTargets) {
            targets.addAll(target.createTarget(sender, this.permission, this.notification));
            mentionSegments.add(target.createMention());
        }
        this.mentionProcessor.broadcastMentions(targets);
        mentionSegments.sort(Comparator.comparing(MentionSegment::begin));
        return mentionSegments;
    }
}

