/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.mention;

import io.github.hanhy06.embellishchat.config.Config;
import io.github.hanhy06.embellishchat.config.ConfigListener;
import io.github.hanhy06.embellishchat.mention.data.Cooldown;
import io.github.hanhy06.embellishchat.mention.data.Mention;
import io.github.hanhy06.embellishchat.mention.data.Target;
import io.github.hanhy06.embellishchat.mention.rule.MentionParameter;
import io.github.hanhy06.embellishchat.mention.rule.MentionRegistry;
import io.github.hanhy06.embellishchat.mention.rule.MentionRule;
import io.github.hanhy06.embellishchat.util.OptionUtil;
import io.github.hanhy06.embellishchat.util.PlaceHolderUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class MentionProcessor
implements ConfigListener {
    private final class_3324 manager;
    private final class_269 scoreboard;
    private final HashSet<Cooldown> cooldowns;
    private Config config;
    private Map<String, List<MentionRule>> mentionRules;
    private MentionRegistry registries;
    private HashSet<UUID> notificationOffPlayerList;
    private boolean notification;

    public MentionProcessor(class_3324 manager, class_269 scoreboard) {
        this.manager = manager;
        this.scoreboard = scoreboard;
        this.cooldowns = new HashSet();
        ServerTickEvents.START_SERVER_TICK.register(tick -> {
            Instant now = Instant.now();
            this.cooldowns.removeIf(cooldown -> now.isAfter(cooldown.end()));
        });
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.config = newConfig;
        this.mentionRules = this.config.mentionRules();
        this.registries = new MentionRegistry(newConfig, this.manager, this.scoreboard);
        this.cooldowns.clear();
        this.notificationOffPlayerList = this.config.notificationOffPlayerList();
        this.notification = this.config.notificationCommandEnable();
    }

    public List<Mention> handleMention(String text, List<String> keys, class_3222 player) {
        ArrayList rules = new ArrayList();
        keys.forEach(key -> rules.addAll(this.mentionRules.get(key)));
        Set<Mention> mentions = new HashSet<Mention>();
        for (MentionRule rule : rules) {
            Cooldown cooldown = new Cooldown(player.method_5667(), Instant.now().plusSeconds(rule.cooldown()), rule);
            if (this.cooldowns.contains(cooldown)) continue;
            if (rule.cooldown() > 0) {
                this.cooldowns.add(cooldown);
            }
            mentions.addAll(this.parseMention(text, rule));
        }
        mentions = this.parseTarget(mentions, player);
        this.mentionBroadcast(mentions, player);
        return new ArrayList<Mention>(mentions);
    }

    private Set<Mention> parseTarget(Set<Mention> mentions, class_3222 player) {
        HashSet<Mention> result = new HashSet<Mention>();
        for (Mention mention : mentions) {
            ArrayList functions = new ArrayList();
            ArrayList<String> presets = new ArrayList<String>();
            mention.rule().mentions().forEach(action -> {
                functions.add(this.registries.get(action.mentionType()));
                presets.add(action.preset());
            });
            List<String> options = mention.options();
            options = OptionUtil.parseOption(options, presets, player);
            HashSet<class_3222> targets = new HashSet<class_3222>();
            class_2583 style = class_2583.field_24360;
            for (int i = 0; i < functions.size(); ++i) {
                MentionParameter parameter = MentionParameter.of(player, options.get(i));
                Target target = (Target)((Function)functions.get(i)).apply(parameter);
                if (targets.isEmpty()) {
                    targets.addAll(target.targets());
                    style = target.style();
                    continue;
                }
                targets.retainAll(target.targets());
            }
            Mention newMention = new Mention(mention.begin(), mention.end(), null, targets, style, mention.rule());
            result.add(newMention);
        }
        return result;
    }

    private Set<Mention> parseMention(String text, MentionRule rule) {
        HashSet<Mention> mentions = new HashSet<Mention>();
        Matcher matcher = rule.pattern().matcher(text);
        while (matcher.find()) {
            int begin = matcher.start();
            int end = matcher.end();
            List<String> options = OptionUtil.split(matcher.group(1), this.config.delimiter());
            Mention mention = Mention.of(begin, end, options, rule);
            mentions.add(mention);
        }
        return mentions;
    }

    private void mentionBroadcast(Set<Mention> mentions, class_3222 player) {
        for (Mention mention : mentions) {
            class_2561 title = PlaceHolderUtil.getParedOption(mention.rule().title(), player);
            class_3414 sound = class_3414.method_47908((class_2960)mention.rule().sound());
            float pitch = mention.rule().pitch();
            mention.targets().forEach(target -> {
                if (this.notification && this.notificationOffPlayerList.contains(target.method_5667())) {
                    return;
                }
                target.method_7353(title, true);
                target.method_17356(sound, class_3419.field_61058, 1.0f, pitch);
            });
        }
    }
}

