/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.message;

import com.hanhy06.embellish_chat.config.Config;
import com.hanhy06.embellish_chat.config.ConfigListener;
import com.hanhy06.embellish_chat.mention.MentionProcessor;
import com.hanhy06.embellish_chat.mention.data.Mention;
import com.hanhy06.embellish_chat.styling.StylingProcessor;
import com.hanhy06.embellish_chat.util.PermissionUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_7471;

public class MessageProcessor
implements ConfigListener {
    public static MessageProcessor INSTANCE;
    private final MentionProcessor mentionProcessor;
    private final StylingProcessor stylingManager;
    private final class_3324 playerManager;
    private Config config;
    private List<UUID> bannedPlayerList;

    public MessageProcessor(MentionProcessor mentionProcessor, StylingProcessor stylingManager, class_3324 playerManager) {
        INSTANCE = this;
        this.mentionProcessor = mentionProcessor;
        this.stylingManager = stylingManager;
        this.playerManager = playerManager;
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.config = newConfig;
        this.bannedPlayerList = this.config.bannedPlayerList();
    }

    public class_7471 handleMessage(class_7471 message) {
        if (this.bannedPlayerList.contains(message.method_46292())) {
            return message;
        }
        class_5250 textMessage = message.method_46291().method_27661();
        String stringMessage = message.method_46291().getString();
        class_3222 sender = this.playerManager.method_14602(message.method_46292());
        ArrayList<Mention> mentions = new ArrayList<Mention>();
        for (String key : PermissionUtil.getPermissionsKeys(sender, "mention", this.config.mentionRules().keySet())) {
            List<Mention> mention = this.mentionProcessor.handleMention(sender, stringMessage, key);
            mentions.addAll(mention);
        }
        mentions.sort(Comparator.comparing(Mention::begin));
        textMessage = this.stylingManager.applyMention(textMessage, mentions);
        for (String key : PermissionUtil.getPermissionsKeys(sender, "chat", this.config.stylingRules().keySet())) {
            textMessage = this.stylingManager.applyStylingRule(textMessage, key);
        }
        return message.method_44863((class_2561)textMessage);
    }
}

