/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.styling;

import com.hanhy06.embellish_chat.config.Config;
import com.hanhy06.embellish_chat.config.ConfigListener;
import com.hanhy06.embellish_chat.mention.data.Mention;
import com.hanhy06.embellish_chat.styling.rule.StyleAction;
import com.hanhy06.embellish_chat.styling.rule.StyleParameter;
import com.hanhy06.embellish_chat.styling.rule.StyleRegistry;
import com.hanhy06.embellish_chat.styling.rule.StylingRule;
import com.hanhy06.embellish_chat.styling.util.Runs;
import com.hanhy06.embellish_chat.styling.util.TextSliceUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class StylingProcessor
implements ConfigListener {
    public static StylingProcessor INSTANCE;
    private Config config;
    private Map<String, List<StylingRule>> stylingRules;
    private StyleRegistry registry;

    public StylingProcessor() {
        INSTANCE = this;
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.config = newConfig;
        this.stylingRules = newConfig.stylingRules();
        this.registry = new StyleRegistry(newConfig);
    }

    public class_5250 applyStylingRule(class_5250 text, String key) {
        if (text.getString().isBlank() || !this.stylingRules.containsKey(key)) {
            return text;
        }
        class_5250 result = text;
        for (StylingRule style : this.stylingRules.get(key)) {
            result = this.applyStyles(result, style);
        }
        return result;
    }

    private class_5250 applyStyles(class_5250 text, StylingRule style) {
        Runs runs = TextSliceUtil.flatten((class_2561)text);
        class_5250 result = class_2561.method_43473();
        Matcher matcher = style.pattern().matcher(runs.full());
        if (!matcher.find()) {
            return text;
        }
        int lastEnd = 0;
        do {
            result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, matcher.start()));
            class_5250 segment = TextSliceUtil.slice(runs, matcher.start(1), matcher.end(1));
            String option = matcher.group(2);
            List<String> options = List.of();
            if (option != null && !option.isBlank()) {
                options = List.of(option.split(this.config.delimiter()));
            }
            result.method_10852((class_2561)this.applyStyle(segment, style.styles(), options));
            lastEnd = matcher.end();
        } while (matcher.find());
        result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, runs.full().length()));
        return result;
    }

    private class_5250 applyStyle(class_5250 text, List<StyleAction> actions, List<String> options) {
        class_5250 result = text;
        int index = 0;
        for (StyleAction action : actions) {
            String option = action.preset();
            if (option.isBlank() && index < options.size()) {
                option = options.get(index);
            }
            result = this.registry.get(action.styleType()).apply(StyleParameter.of(result, option));
            ++index;
        }
        return result;
    }

    public class_5250 applyMention(class_5250 text, List<Mention> mentions) {
        Runs runs = TextSliceUtil.flatten((class_2561)text);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        for (Mention mention : mentions) {
            result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, mention.begin()));
            class_5250 segment = TextSliceUtil.slice(runs, mention.begin(), mention.end());
            segment.method_27696(mention.style());
            for (StyleAction action : mention.styles()) {
                segment = this.registry.get(action.styleType()).apply(StyleParameter.of(segment, action.preset()));
            }
            result.method_10852((class_2561)segment);
            lastEnd = mention.end();
        }
        result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, runs.full().length()));
        return result;
    }
}

