/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.styling.rule;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.hanhy06.embellishchat.EmbellishChat;
import io.github.hanhy06.embellishchat.config.Config;
import io.github.hanhy06.embellishchat.styling.rule.StyleParameter;
import io.github.hanhy06.embellishchat.styling.rule.StyleType;
import io.github.hanhy06.embellishchat.styling.util.Runs;
import io.github.hanhy06.embellishchat.styling.util.TextSliceUtil;
import io.github.hanhy06.embellishchat.util.ColorUtil;
import java.awt.Color;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_11719;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import net.minecraft.server.MinecraftServer;

public class StyleRegistry {
    private final Config config;
    private final DateTimeFormatter timestamp;
    private final HashMap<String, Color> colorPreset;
    private final EnumMap<StyleType, Function<StyleParameter, class_5250>> registers;
    private final Pattern HEX_CODE = Pattern.compile("#[A-Fa-f0-9]{6}");

    public StyleRegistry(Config config) {
        this.config = config;
        this.timestamp = DateTimeFormatter.ofPattern(config.timestamp());
        this.colorPreset = config.colorPreset();
        this.registers = new EnumMap(Map.ofEntries(Map.entry(StyleType.METADATA, this::METADATA), Map.entry(StyleType.LOG, this::LOG), Map.entry(StyleType.COLOR_HEX, this::COLOR_HEX), Map.entry(StyleType.COLOR_RAINBOW, this::COLOR_RAINBOW), Map.entry(StyleType.COLOR_GRADIENT, this::COLOR_GRADIENT), Map.entry(StyleType.COLOR_PRESET, this::COLOR_PRESET), Map.entry(StyleType.COLOR_SHADOW, this::COLOR_SHADOW), Map.entry(StyleType.COMMAND_RUN, this::COMMAND_RUN), Map.entry(StyleType.CLICK_COMMAND_RUN, this::CLICK_COMMAND_RUN), Map.entry(StyleType.CLICK_COMMAND_SUGGEST, this::CLICK_COMMAND_SUGGEST), Map.entry(StyleType.CLICK_COPY, this::CLICK_COPY), Map.entry(StyleType.HOVER_TEXT, this::HOVER_TEXT), Map.entry(StyleType.HOVER_ITEM, this::HOVER_ITEM), Map.entry(StyleType.FONT, this::FONT), Map.entry(StyleType.URL, this::URL), Map.entry(StyleType.BOLD, this::BOLD), Map.entry(StyleType.ITALIC, this::ITALIC), Map.entry(StyleType.UNDERLINE, this::UNDERLINE), Map.entry(StyleType.STRIKETHROUGH, this::STRIKETHROUGH), Map.entry(StyleType.OBFUSCATED, this::OBFUSCATED), Map.entry(StyleType.REPLACE, this::REPLACE), Map.entry(StyleType.MASK, this::MASK), Map.entry(StyleType.UPPER, this::UPPER), Map.entry(StyleType.LOWER, this::LOWER), Map.entry(StyleType.JSON, this::JSON)));
    }

    public Function<StyleParameter, class_5250> get(StyleType styleType) {
        return this.registers.get((Object)styleType);
    }

    public class_5250 METADATA(StyleParameter parameter) {
        class_5250 text = parameter.text();
        String now = LocalDateTime.now().format(this.timestamp);
        class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)(now + "\nClick to copy to clipboard")));
        class_2558.class_10606 clickEvent = new class_2558.class_10606(now + " " + text.getString());
        return text.method_27696(class_2583.field_24360.method_10949((class_2568)hoverEvent).method_10958((class_2558)clickEvent));
    }

    public class_5250 LOG(StyleParameter parameter) {
        EmbellishChat.LOGGER.info("Log StyleType text: {}, sender: {}", (Object)parameter.text().getString(), (Object)parameter.player());
        return parameter.text();
    }

    public class_5250 COLOR_HEX(StyleParameter parameter) {
        int color = 0xFFFFFF;
        try {
            color = Color.decode(parameter.option()).getRGB();
        }
        catch (NumberFormatException e) {
            EmbellishChat.LOGGER.warn("Invalid hex color format: {}", (Object)parameter.option());
        }
        catch (NullPointerException e) {
            EmbellishChat.LOGGER.warn("The option value you entered is null.");
        }
        return parameter.text().method_27696(class_2583.field_24360.method_36139(color));
    }

    public class_5250 COLOR_RAINBOW(StyleParameter parameter) {
        Runs runs = TextSliceUtil.flatten((class_2561)parameter.text());
        String string = runs.full();
        int length = string.length();
        float saturation = 0.7f;
        try {
            saturation = Float.parseFloat(parameter.option());
        }
        catch (NumberFormatException e) {
            EmbellishChat.LOGGER.warn("The option value you entered is not a valid number.");
        }
        catch (NullPointerException e) {
            EmbellishChat.LOGGER.warn("The option value you entered is null.");
        }
        class_5250 result = class_2561.method_43473();
        for (int i = 0; i < length; ++i) {
            float hue = (float)i / (float)length;
            int rgb = Color.HSBtoRGB(hue, saturation, 1.0f);
            result.method_10852((class_2561)TextSliceUtil.slice(runs, i, i + 1).method_27696(class_2583.field_24360.method_36139(rgb)));
        }
        return result;
    }

    public class_5250 COLOR_GRADIENT(StyleParameter parameter) {
        Matcher matcher = this.HEX_CODE.matcher(parameter.option());
        if (!matcher.find()) {
            return parameter.text();
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        String string = parameter.text().getString();
        int length = string.length();
        do {
            colors.add(Color.decode(matcher.group()));
        } while (matcher.find());
        if (colors.size() < 2 || length < colors.size()) {
            return parameter.text().method_27696(class_2583.field_24360.method_36139(((Color)colors.getFirst()).getRGB()));
        }
        Runs runs = TextSliceUtil.flatten((class_2561)parameter.text());
        class_5250 result = class_2561.method_43473();
        int colorCount = colors.size();
        for (int i = 0; i < length; ++i) {
            float position = (float)i / (float)(length - 1);
            float scaledPosition = position * (float)(colorCount - 1);
            int segmentIndex = Math.min((int)scaledPosition, colorCount - 2);
            float t = scaledPosition - (float)segmentIndex;
            Color interpolated = ColorUtil.lerpColor((Color)colors.get(segmentIndex), (Color)colors.get(segmentIndex + 1), t);
            result.method_10852((class_2561)TextSliceUtil.slice(runs, i, i + 1).method_27696(class_2583.field_24360.method_36139(interpolated.getRGB())));
        }
        return result;
    }

    public class_5250 COLOR_PRESET(StyleParameter parameter) {
        Color color = this.colorPreset.getOrDefault(parameter.option(), Color.WHITE);
        return parameter.text().method_27696(class_2583.field_24360.method_36139(color.getRGB()));
    }

    public class_5250 COLOR_SHADOW(StyleParameter parameter) {
        int color = 0xFFFFFF;
        try {
            color = Color.decode(parameter.option()).getRGB();
        }
        catch (NumberFormatException e) {
            EmbellishChat.LOGGER.warn("Invalid hex color format: {}", (Object)parameter.option());
        }
        catch (NullPointerException e) {
            EmbellishChat.LOGGER.warn("The option value you entered is null.");
        }
        return parameter.text().method_27696(class_2583.field_24360.method_65302(color));
    }

    public class_5250 COMMAND_RUN(StyleParameter parameter) {
        class_3222 player = parameter.player();
        MinecraftServer server = player.method_64396().method_9211();
        String command = parameter.option();
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        if (server != null) {
            class_2168 commandSource = player.method_64396();
            try {
                server.method_3734().method_9235().execute(command, (Object)commandSource);
            }
            catch (Exception e) {
                EmbellishChat.LOGGER.error("Failed to execute command: {}", (Object)command, (Object)e);
            }
        }
        return parameter.text();
    }

    public class_5250 CLICK_COMMAND_RUN(StyleParameter parameter) {
        class_2558.class_10609 clickEvent = new class_2558.class_10609(parameter.option());
        return parameter.text().method_27696(class_2583.field_24360.method_10958((class_2558)clickEvent));
    }

    public class_5250 CLICK_COMMAND_SUGGEST(StyleParameter parameter) {
        class_2558.class_10610 clickEvent = new class_2558.class_10610(parameter.option());
        return parameter.text().method_27696(class_2583.field_24360.method_10958((class_2558)clickEvent));
    }

    public class_5250 CLICK_COPY(StyleParameter parameter) {
        class_2558.class_10606 clickEvent = new class_2558.class_10606(parameter.option());
        return parameter.text().method_27696(class_2583.field_24360.method_10958((class_2558)clickEvent));
    }

    public class_5250 HOVER_TEXT(StyleParameter parameter) {
        class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)parameter.option()));
        return parameter.text().method_27696(class_2583.field_24360.method_10949((class_2568)hoverEvent));
    }

    public class_5250 HOVER_ITEM(StyleParameter parameter) {
        class_1799 handItem = parameter.player().method_6047();
        if (handItem.method_7960()) {
            return parameter.text();
        }
        class_2568.class_10612 hoverEvent = new class_2568.class_10612(handItem);
        return parameter.text().method_27696(class_2583.field_24360.method_10949((class_2568)hoverEvent));
    }

    public class_5250 FONT(StyleParameter parameter) {
        class_11719.class_11721 font = new class_11719.class_11721(class_2960.method_12829((String)parameter.option()));
        return parameter.text().method_27696(class_2583.field_24360.method_27704((class_11719)font));
    }

    public class_5250 URL(StyleParameter parameter) {
        try {
            URI uri = URI.create(parameter.option());
            class_2558.class_10608 clickEvent = new class_2558.class_10608(uri);
            return parameter.text().method_27696(class_2583.field_24360.method_10958((class_2558)clickEvent).method_36139(this.config.urlColor().getRGB()));
        }
        catch (IllegalArgumentException e) {
            EmbellishChat.LOGGER.warn("Invalid URL provided for text [{}]: {}", (Object)parameter.text().getString(), (Object)parameter.option());
            return parameter.text();
        }
    }

    public class_5250 BOLD(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
    }

    public class_5250 ITALIC(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)));
    }

    public class_5250 UNDERLINE(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
    }

    public class_5250 OBFUSCATED(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_36141(Boolean.valueOf(true)));
    }

    public class_5250 STRIKETHROUGH(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_36140(Boolean.valueOf(true)));
    }

    public class_5250 REPLACE(StyleParameter parameter) {
        return class_2561.method_30163((String)parameter.option()).method_27661().method_27696(parameter.text().method_10866());
    }

    public class_5250 MASK(StyleParameter parameter) {
        int length = parameter.text().getString().length();
        return class_2561.method_30163((String)parameter.option().repeat(length)).method_27661().method_27696(parameter.text().method_10866());
    }

    public class_5250 UPPER(StyleParameter parameter) {
        String string = parameter.text().getString();
        return class_2561.method_30163((String)string.toUpperCase()).method_27661().method_27696(parameter.text().method_10866());
    }

    public class_5250 LOWER(StyleParameter parameter) {
        String string = parameter.text().getString();
        return class_2561.method_30163((String)string.toLowerCase()).method_27661().method_27696(parameter.text().method_10866());
    }

    public class_5250 JSON(StyleParameter parameter) {
        JsonElement element = JsonParser.parseString((String)parameter.option());
        class_2561 text = (class_2561)class_8824.field_46597.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow();
        return text.method_27661();
    }
}

