/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.hanhy06.embellishchat.config.ConfigManager;
import io.github.hanhy06.embellishchat.mention.rule.MentionAction;
import io.github.hanhy06.embellishchat.mention.rule.MentionRule;
import io.github.hanhy06.embellishchat.styling.rule.StyleAction;
import io.github.hanhy06.embellishchat.styling.rule.StylingRule;
import io.github.hanhy06.embellishchat.util.LuckPermsUtil;
import io.github.hanhy06.embellishchat.util.PermissionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class EcCommand {
    public static void registerEc() {
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess, registrationEnvironment) -> commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ec").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"help").then(class_2170.method_9247((String)"mention").executes(EcCommand::executeHelpMention))).then(class_2170.method_9247((String)"style").executes(EcCommand::executeHelpStyle)))).then(class_2170.method_9247((String)"notification").executes(EcCommand::executeNotification))));
    }

    private static int executeHelpMention(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 1;
        }
        player.method_64398((class_2561)class_2561.method_43470((String)"--- Available Mentions ---"));
        List<String> keys = PermissionUtil.getPermissions(player, ConfigManager.getConfig().mentionRules().keySet());
        ArrayList rules = new ArrayList();
        for (String key : keys) {
            rules.addAll(ConfigManager.getConfig().mentionRules().get(key));
        }
        for (MentionRule rule : rules) {
            String pattern = rule.pattern().pattern();
            String mentionTypes = rule.mentions().stream().map(MentionAction::mentionType).map(Enum::name).collect(Collectors.joining(", "));
            String styles = rule.styles().stream().map(StyleAction::styleType).map(Enum::name).collect(Collectors.joining(", "));
            String message = String.format("Pattern: %s\nTargets: %s\nStyles: %s\n", pattern, mentionTypes, styles);
            player.method_64398((class_2561)class_2561.method_43470((String)message));
        }
        return 1;
    }

    private static int executeHelpStyle(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 1;
        }
        player.method_64398((class_2561)class_2561.method_43470((String)"--- Available Styles ---"));
        List<String> keys = PermissionUtil.getPermissions(player, ConfigManager.getConfig().stylingRules().keySet());
        ArrayList rules = new ArrayList();
        for (String key : keys) {
            rules.addAll(ConfigManager.getConfig().stylingRules().get(key));
        }
        for (StylingRule rule : rules) {
            String pattern = rule.pattern().pattern();
            String styles = rule.styles().stream().map(StyleAction::styleType).map(Enum::name).collect(Collectors.joining(", "));
            String presetOptions = rule.styles().stream().map(StyleAction::preset).map(str -> String.format("%s", str.isBlank() ? "user input" : str)).collect(Collectors.joining(ConfigManager.getConfig().delimiter()));
            String message = String.format("Pattern: %s\nStyles: %s\nPreset Options: %s\n", pattern, styles, presetOptions);
            player.method_64398((class_2561)class_2561.method_43470((String)message));
        }
        return 1;
    }

    private static int executeNotification(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 1;
        }
        if (!FabricLoader.getInstance().isModLoaded("luckperms")) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"LuckPerms is not installed. Notification settings are unavailable."), false);
            return 1;
        }
        boolean notification = !LuckPermsUtil.getNotification(player);
        LuckPermsUtil.setNotification(player, notification);
        String result = String.format("Mention notifications set to: %s", notification ? "ON" : "OFF");
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)result), false);
        return 1;
    }
}

