/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.config.adapter;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.hanhy06.embellishchat.EmbellishChat;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternTypeAdapter
extends TypeAdapter<Pattern> {
    public void write(JsonWriter jsonWriter, Pattern pattern) throws IOException {
        if (pattern == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.value(pattern.pattern());
    }

    public Pattern read(JsonReader jsonReader) throws IOException {
        JsonToken token = jsonReader.peek();
        if (token == JsonToken.NULL) {
            jsonReader.nextNull();
            throw new JsonSyntaxException("Cannot parse JSON null as a pattern pattern.");
        }
        if (token != JsonToken.STRING) {
            throw new JsonSyntaxException("Expected a string for a pattern pattern, but found " + String.valueOf(token) + ".");
        }
        String regex = jsonReader.nextString();
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            EmbellishChat.LOGGER.error("Failed to compile regex pattern from config: \"{}\"", (Object)regex, (Object)e);
            throw new JsonSyntaxException("Invalid pattern pattern: \"" + regex + "\"", (Throwable)e);
        }
    }
}

