/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.util;

import io.github.hanhy06.embellishchat.EmbellishChat;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.MetaNode;
import net.minecraft.class_3222;

public class LuckPermsUtil {
    public static boolean getNotification(class_3222 player) {
        try {
            LuckPerms luckPerms = LuckPermsProvider.get();
            User user = luckPerms.getUserManager().getUser(player.method_5667());
            if (user == null) {
                return true;
            }
            String notificationValue = user.getCachedData().getMetaData().getMetaValue("embellish-chat-notification");
            return notificationValue == null || "true".equals(notificationValue);
        }
        catch (IllegalStateException e) {
            EmbellishChat.LOGGER.warn("LuckPerms API is not ready. Failed to check notification metadata.", (Throwable)e);
            return true;
        }
    }

    public static void setNotification(class_3222 player, boolean bool) {
        if (!FabricLoader.getInstance().isModLoaded("luckperms")) {
            return;
        }
        try {
            LuckPerms luckPerms = LuckPermsProvider.get();
            User user = luckPerms.getUserManager().getUser(player.method_5667());
            if (user == null) {
                return;
            }
            user.data().remove((Node)MetaNode.builder((String)"embellish-chat-notification", (String)String.valueOf(!bool)).build());
            user.data().add((Node)MetaNode.builder((String)"embellish-chat-notification", (String)String.valueOf(bool)).build());
            luckPerms.getUserManager().saveUser(user);
        }
        catch (IllegalStateException e) {
            EmbellishChat.LOGGER.warn("LuckPerms API is not ready. Failed to set notification metadata.", (Throwable)e);
        }
    }

    public static List<class_3222> getGroupPlayers(String targetGroup, List<class_3222> players) {
        List<class_3222> result = new ArrayList<class_3222>();
        try {
            LuckPerms luckPerms = LuckPermsProvider.get();
            result = players.stream().filter(player -> {
                User user = luckPerms.getUserManager().getUser(player.method_5667());
                return user != null && targetGroup.equals(user.getPrimaryGroup());
            }).toList();
        }
        catch (IllegalStateException exception) {
            EmbellishChat.LOGGER.warn("LuckPerms API is not ready. Failed to process @group mention.", (Throwable)exception);
        }
        return result;
    }
}

