/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib;

import com.lowdragmc.lowdraglib.gui.factory.UIEditorFactory;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ServerCommands {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> createServerCommands() {
        return List.of((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ldlib").then(Commands.literal((String)"ui_editor").executes(context -> {
            UIEditorFactory.INSTANCE.openUI(UIEditorFactory.INSTANCE, ((CommandSourceStack)context.getSource()).getPlayerOrException());
            return 1;
        }))).then(Commands.literal((String)"copy_block_tag").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos");
            ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity != null) {
                CompoundTag tag = blockEntity.saveWithoutMetadata();
                String value = NbtUtils.structureToSnbt((CompoundTag)tag);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"[Copy to clipboard]").withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, value))).append(NbtUtils.toPrettyComponent((Tag)tag)), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("No block entity at " + String.valueOf(pos))).withStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
            }
            return 1;
        })))).then(Commands.literal((String)"copy_entity_tag").then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).executes(context -> {
            Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"entity");
            CompoundTag tag = entity.saveWithoutId(new CompoundTag());
            String value = NbtUtils.structureToSnbt((CompoundTag)tag);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"[Copy to clipboard]").withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, value))).append(NbtUtils.toPrettyComponent((Tag)tag)), true);
            return 1;
        }))), (LiteralArgumentBuilder)Commands.literal((String)"compass_server").then(Commands.literal((String)"build_scene").then(Commands.argument((String)"start", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"end", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> ServerCommands.runBuildScene((CommandContext<CommandSourceStack>)context, false, new BlockPos(0, 0, 0)))).then(((RequiredArgumentBuilder)Commands.argument((String)"saveNbt", (ArgumentType)BoolArgumentType.bool()).executes(context -> ServerCommands.runBuildScene((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"saveNbt"), new BlockPos(0, 0, 0)))).then(Commands.argument((String)"offset", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> ServerCommands.runBuildScene((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"saveNbt"), BlockPosArgument.getBlockPos((CommandContext)context, (String)"offset")))))))));
    }

    public static int runBuildScene(CommandContext<CommandSourceStack> context, boolean saveNbt, BlockPos offset) {
        BlockPos start = BlockPosArgument.getBlockPos(context, (String)"start");
        BlockPos end = BlockPosArgument.getBlockPos(context, (String)"end");
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        int smallestX = start.getX() <= end.getX() ? start.getX() : end.getX();
        int smallestY = start.getY() <= end.getY() ? start.getY() : end.getY();
        int smallestZ = start.getZ() <= end.getZ() ? start.getZ() : end.getZ();
        int largestX = start.getX() >= end.getX() ? start.getX() : end.getX();
        int largestY = start.getY() >= end.getY() ? start.getY() : end.getY();
        int largestZ = start.getZ() >= end.getZ() ? start.getZ() : end.getZ();
        int offsetX = -((largestX - smallestX) / 2) + offset.getX();
        int offsetY = offset.getY();
        int offsetZ = -((largestZ - smallestZ) / 2) + offset.getZ();
        ArrayList<String> nodes = new ArrayList<String>();
        for (int x = smallestX; x <= largestX; ++x) {
            for (int y = smallestY; y <= largestY; ++y) {
                for (int z = smallestZ; z <= largestZ; ++z) {
                    BlockState block = world.getBlockState(new BlockPos(x, y, z));
                    BlockEntity blockentity = world.getBlockEntity(new BlockPos(x, y, z));
                    if (block.getBlock() == Blocks.AIR) continue;
                    String id = BuiltInRegistries.BLOCK.getKey((Object)block.getBlock()).toString();
                    nodes.add(String.format("<add pos=\"%d %d %d\" block=\"%s\">", x - smallestX + offsetX, y - smallestY + offsetY, z - smallestZ + offsetZ, id));
                    nodes.addAll(block.getValues().entrySet().stream().map(e -> String.format("<properties name=\"%s\" value=\"%s\" />", ((Property)e.getKey()).getName(), ((Comparable)e.getValue()).toString())).collect(Collectors.toList()));
                    if (saveNbt && blockentity != null) {
                        CompoundTag tag = blockentity.saveWithoutMetadata();
                        nodes.add("<nbt>");
                        nodes.add(NbtUtils.toPrettyComponent((Tag)tag).getString());
                        nodes.add("</nbt>");
                    }
                    nodes.add("</add>");
                }
            }
        }
        String text = nodes.stream().collect(Collectors.joining("\n"));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"[Copy XML to clipboard]").withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text))), true);
        return 1;
    }
}

