/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.forge;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.ClientProxy;
import com.lowdragmc.lowdraglib.client.model.custommodel.LDLMetadataSection;
import com.lowdragmc.lowdraglib.client.model.forge.CustomBakedModelImpl;
import com.lowdragmc.lowdraglib.client.model.forge.LDLRendererModel;
import com.lowdragmc.lowdraglib.client.renderer.ATESRRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.block.RendererBlock;
import com.lowdragmc.lowdraglib.client.renderer.block.forge.RendererBlockEntityImpl;
import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.client.utils.WidgetClientTooltipComponent;
import com.lowdragmc.lowdraglib.core.mixins.accessor.ModelBakeryAccessor;
import com.lowdragmc.lowdraglib.forge.CommonProxyImpl;
import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.util.WidgetTooltipComponent;
import com.lowdragmc.lowdraglib.test.TestBlock;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxyImpl
extends CommonProxyImpl {
    @SubscribeEvent
    public void onRegisterClientTooltipComponentFactoriesEvent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(WidgetTooltipComponent.class, WidgetClientTooltipComponent::new);
    }

    @SubscribeEvent
    public void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(RendererBlockEntityImpl.TYPE(), ATESRRendererProvider::new);
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent e) {
        e.enqueueWork(() -> {
            ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener((PreparableReloadListener)CompassManager.INSTANCE);
            CompassManager.INSTANCE.onResourceManagerReload(Minecraft.getInstance().getResourceManager());
            ClientProxy.init();
            ItemBlockRenderTypes.setRenderLayer((Block)RendererBlock.BLOCK, (RenderType)RenderType.translucent());
            if (Platform.isDevEnv()) {
                ItemBlockRenderTypes.setRenderLayer((Block)TestBlock.BLOCK, (RenderType)RenderType.cutoutMipped());
            }
        });
    }

    @SubscribeEvent
    public void modelRegistry(ModelEvent.RegisterGeometryLoaders e) {
        e.register("renderer", (IGeometryLoader)LDLRendererModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    public void modelBake(ModelEvent.ModifyBakingResult event) {
        ModelBakery modelBakery = event.getModelBakery();
        for (Map.Entry entry : event.getModels().entrySet()) {
            BakedModel baked;
            ResourceLocation rl = (ResourceLocation)entry.getKey();
            UnbakedModel rootModel = ((ModelBakeryAccessor)modelBakery).getTopLevelModels().get(rl);
            if (rootModel == null || (baked = (BakedModel)entry.getValue()) instanceof LDLRendererModel || baked.isCustomRenderer()) continue;
            ArrayDeque<ResourceLocation> dependencies = new ArrayDeque<ResourceLocation>();
            HashSet<ResourceLocation> seenModels = new HashSet<ResourceLocation>();
            dependencies.push(rl);
            seenModels.add(rl);
            boolean shouldWrap = ClientProxy.WRAPPED_MODELS.getOrDefault((Object)rl, false);
            while (!shouldWrap && !dependencies.isEmpty()) {
                UnbakedModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == rl ? rootModel : modelBakery.getModel(dep);
                }
                catch (Exception e) {
                    continue;
                }
                try {
                    HashSet textures = new HashSet(ClientProxy.SCRAPED_TEXTURES.get((Object)dep));
                    for (Material tex : textures) {
                        if (LDLMetadataSection.getMetadata(LDLMetadataSection.spriteToAbsolute(tex.texture())).isMissing()) continue;
                        shouldWrap = true;
                        break;
                    }
                    if (shouldWrap) continue;
                    for (ResourceLocation newDep : model.getDependencies()) {
                        if (!seenModels.add(newDep)) continue;
                        dependencies.push(newDep);
                    }
                }
                catch (Exception e) {
                    LDLib.LOGGER.error("Error loading model dependency {} for model {}. Skipping...", new Object[]{dep, rl, e});
                }
            }
            ClientProxy.WRAPPED_MODELS.put((Object)rl, shouldWrap);
            if (!shouldWrap) continue;
            entry.setValue(new CustomBakedModelImpl(baked));
        }
    }

    @SubscribeEvent
    public void shaderRegistry(RegisterShadersEvent event) {
        for (Pair<ShaderInstance, Consumer<ShaderInstance>> pair : Shaders.registerShaders(event.getResourceProvider())) {
            event.registerShader((ShaderInstance)pair.getFirst(), (Consumer)pair.getSecond());
        }
    }

    @SubscribeEvent
    public void registerModels(ModelEvent.RegisterAdditional event) {
        for (Map.Entry entry : Minecraft.getInstance().getResourceManager().listResources("models", id -> id.getNamespace().equals("ldlib") && id.getPath().endsWith(".json")).entrySet()) {
            if (!((Resource)entry.getValue()).sourcePackId().equals("ldlib")) continue;
            event.register(new ResourceLocation(((ResourceLocation)entry.getKey()).getNamespace(), ((ResourceLocation)entry.getKey()).getPath().replace("models/", "").replace(".json", "")));
        }
        for (IRenderer renderer : IRenderer.EVENT_REGISTERS) {
            renderer.onAdditionalModel(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        }
    }
}

