/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.model;

import com.google.gson.JsonParseException;
import com.lowdragmc.lowdraglib.client.model.forge.ModelFactoryImpl;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import dev.architectury.injectables.annotations.ExpectPlatform;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class ModelFactory {
    public static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    public static final ItemTransform TRANSFORM_BLOCK_GUI = ModelFactory.makeTransform(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    public static final ItemTransform TRANSFORM_BLOCK_GROUND = ModelFactory.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
    public static final ItemTransform TRANSFORM_BLOCK_FIXED = ModelFactory.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
    public static final ItemTransform TRANSFORM_BLOCK_3RD_PERSON_RIGHT = ModelFactory.makeTransform(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
    public static final ItemTransform TRANSFORM_BLOCK_1ST_PERSON_RIGHT = ModelFactory.makeTransform(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    public static final ItemTransform TRANSFORM_BLOCK_1ST_PERSON_LEFT = ModelFactory.makeTransform(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    public static final ItemTransforms MODEL_TRANSFORM_BLOCK = new ItemTransforms(TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_1ST_PERSON_LEFT, TRANSFORM_BLOCK_1ST_PERSON_RIGHT, ItemTransform.NO_TRANSFORM, TRANSFORM_BLOCK_GUI, TRANSFORM_BLOCK_GROUND, TRANSFORM_BLOCK_FIXED);

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ModelBakery getModeBakery() {
        return ModelFactoryImpl.getModeBakery();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static UnbakedModel getLDLibModel(UnbakedModel vanilla) {
        return ModelFactoryImpl.getLDLibModel(vanilla);
    }

    public static ModelBaker getModeBaker() {
        return new ModelBaker(){

            public UnbakedModel getModel(ResourceLocation location) {
                return ModelFactory.getUnBakedModel(location);
            }

            public BakedModel bake(ResourceLocation location, ModelState transform) {
                BlockModel blockmodel;
                UnbakedModel unbakedmodel = this.getModel(location);
                if (unbakedmodel instanceof BlockModel && (blockmodel = (BlockModel)unbakedmodel).getRootModel() == ModelBakery.GENERATION_MARKER) {
                    return ITEM_MODEL_GENERATOR.generateBlockModel(Material::sprite, blockmodel).bake((ModelBaker)this, blockmodel, Material::sprite, transform, location, false);
                }
                return unbakedmodel.bake((ModelBaker)this, Material::sprite, transform, location);
            }
        };
    }

    public static UnbakedModel getUnBakedModel(ResourceLocation modelLocation) {
        return ModelFactory.getModeBakery().getModel(modelLocation);
    }

    public static Quaternionf getQuaternion(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> new Quaternionf().rotateXYZ(1.5707964f, 0.0f, 0.0f);
            case Direction.DOWN -> new Quaternionf().rotateXYZ(-1.5707964f, 0.0f, 0.0f);
            case Direction.EAST -> new Quaternionf().rotateXYZ(0.0f, -1.5707964f, 0.0f);
            case Direction.WEST -> new Quaternionf().rotateXYZ(0.0f, 1.5707964f, 0.0f);
            case Direction.SOUTH -> new Quaternionf().rotateXYZ(0.0f, (float)Math.PI, 0.0f);
            case Direction.NORTH -> new Quaternionf();
        };
    }

    public static ModelState getRotation(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> BlockModelRotation.X90_Y0;
            case Direction.UP -> BlockModelRotation.X270_Y0;
            case Direction.NORTH -> BlockModelRotation.X0_Y0;
            case Direction.SOUTH -> BlockModelRotation.X0_Y180;
            case Direction.WEST -> BlockModelRotation.X0_Y270;
            case Direction.EAST -> BlockModelRotation.X0_Y90;
        };
    }

    public static Direction modelFacing(Direction side, Direction frontFacing) {
        if (side == frontFacing) {
            return Direction.NORTH;
        }
        if (frontFacing == Direction.NORTH) {
            return side;
        }
        if (frontFacing == Direction.SOUTH) {
            if (side.getAxis() == Direction.Axis.Y) {
                return side;
            }
            return side.getOpposite();
        }
        if (frontFacing == Direction.EAST) {
            if (side.getAxis() == Direction.Axis.Y) {
                return side;
            }
            return side.getCounterClockWise();
        }
        if (frontFacing == Direction.WEST) {
            if (side.getAxis() == Direction.Axis.Y) {
                return side;
            }
            return side.getClockWise();
        }
        if (frontFacing == Direction.UP) {
            if (side == Direction.DOWN) {
                return Direction.SOUTH;
            }
            if (side.getAxis() == Direction.Axis.X) {
                return side;
            }
            if (side == Direction.SOUTH) {
                return Direction.UP;
            }
            if (side == Direction.NORTH) {
                return Direction.DOWN;
            }
        }
        if (frontFacing == Direction.DOWN) {
            if (side == Direction.UP) {
                return Direction.SOUTH;
            }
            if (side.getAxis() == Direction.Axis.X) {
                return side;
            }
            if (side == Direction.SOUTH) {
                return Direction.DOWN;
            }
            if (side == Direction.NORTH) {
                return Direction.UP;
            }
        }
        return side;
    }

    public static ModelState getRotation(Direction facing, boolean lockedUV) {
        if (lockedUV) {
            return new ModelStateWrapper(ModelFactory.getRotation(facing), true);
        }
        return ModelFactory.getRotation(facing);
    }

    public static Either<Material, String> parseTextureLocationOrReference(ResourceLocation pLocation, String pName) {
        if (ModelFactory.isTextureReference(pName)) {
            return Either.right((Object)pName.substring(1));
        }
        ResourceLocation resourcelocation = ResourceLocation.tryParse((String)pName);
        if (resourcelocation == null) {
            throw new JsonParseException(pName + " is not valid resource location");
        }
        return Either.left((Object)new Material(pLocation, resourcelocation));
    }

    public static Either<Material, String> parseBlockTextureLocationOrReference(String pName) {
        if (ModelFactory.isTextureReference(pName)) {
            return Either.right((Object)pName.substring(1));
        }
        ResourceLocation resourcelocation = ResourceLocation.tryParse((String)pName);
        if (resourcelocation == null) {
            throw new JsonParseException(pName + " is not valid resource location");
        }
        return Either.left((Object)new Material(TextureAtlas.LOCATION_BLOCKS, resourcelocation));
    }

    private static boolean isTextureReference(String pStr) {
        return pStr.charAt(0) == '#';
    }

    public static TextureAtlasSprite getBlockSprite(ResourceLocation location) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(location);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation atlas, ResourceLocation location) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(atlas).apply(location);
    }

    public static ItemTransform makeTransform(float rotationX, float rotationY, float rotationZ, float translationX, float translationY, float translationZ, float scaleX, float scaleY, float scaleZ) {
        Vector3f translation = new Vector3f(translationX, translationY, translationZ);
        translation.mul(0.0625f);
        translation.set(Mth.clamp((float)translation.x, (float)-5.0f, (float)5.0f), Mth.clamp((float)translation.y, (float)-5.0f, (float)5.0f), Mth.clamp((float)translation.z, (float)-5.0f, (float)5.0f));
        return new ItemTransform(new Vector3f(rotationX, rotationY, rotationZ), translation, new Vector3f(scaleX, scaleY, scaleZ));
    }

    private record ModelStateWrapper(ModelState modelState, boolean lockedUV) implements ModelState
    {
        @Nonnull
        public Transformation getRotation() {
            return this.modelState.getRotation();
        }

        public boolean isUvLocked() {
            return this.lockedUV;
        }
    }
}

