/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.model.custommodel;

import com.lowdragmc.lowdraglib.utils.ShapeUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;

public enum Connection {
    UP(Direction.UP),
    DOWN(Direction.DOWN),
    LEFT(Direction.EAST),
    RIGHT(Direction.WEST),
    UP_LEFT(Direction.UP, Direction.EAST),
    UP_RIGHT(Direction.UP, Direction.WEST),
    DOWN_LEFT(Direction.DOWN, Direction.EAST),
    DOWN_RIGHT(Direction.DOWN, Direction.WEST);

    public final Direction[] dirs;
    public final BlockPos[] offsets;

    private Connection(Direction ... dirs) {
        this.dirs = dirs;
        this.offsets = new BlockPos[6];
        for (Direction normal : Direction.values()) {
            BlockPos pos = BlockPos.ZERO;
            for (Direction dir : dirs) {
                if (normal.getAxis() == Direction.Axis.Y) {
                    dir = dir.getOpposite();
                }
                pos = pos.relative(dir);
            }
            AABB rotated = ShapeUtils.rotate(new AABB(pos), normal);
            this.offsets[normal.ordinal()] = new BlockPos(Mth.floor((double)((rotated.minX + rotated.maxX) / 2.0)), Mth.floor((double)((rotated.minY + rotated.maxY) / 2.0)), Mth.floor((double)((rotated.minZ + rotated.maxZ) / 2.0)));
        }
    }

    @Nonnull
    public BlockPos getOffset(Direction normal) {
        return this.offsets[normal.ordinal()];
    }

    @Nonnull
    public BlockPos transform(BlockPos pos, Direction normal) {
        return pos.offset((Vec3i)this.getOffset(normal));
    }

    public Connection getOpposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case UP -> DOWN;
            case DOWN -> UP;
            case LEFT -> RIGHT;
            case RIGHT -> LEFT;
            case UP_LEFT -> DOWN_RIGHT;
            case UP_RIGHT -> DOWN_LEFT;
            case DOWN_LEFT -> UP_RIGHT;
            case DOWN_RIGHT -> UP_LEFT;
        };
    }
}

