/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.model.custommodel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LDLMetadataSection {
    public static final String SECTION_NAME = "ldlib";
    private static final Map<ResourceLocation, LDLMetadataSection> METADATA_CACHE = new ConcurrentHashMap<ResourceLocation, LDLMetadataSection>();
    public static final LDLMetadataSection MISSING = new LDLMetadataSection(false, null);
    public final boolean emissive;
    public final ResourceLocation connection;

    public LDLMetadataSection(boolean emissive, ResourceLocation connection) {
        this.emissive = emissive;
        this.connection = connection;
    }

    public static void clearCache() {
        METADATA_CACHE.clear();
    }

    public boolean isMissing() {
        return this == MISSING;
    }

    @Nonnull
    public static LDLMetadataSection getMetadata(ResourceLocation res) {
        if (METADATA_CACHE.containsKey(res)) {
            return METADATA_CACHE.get(res);
        }
        LDLMetadataSection ret = MISSING;
        Optional resourceOptional = Minecraft.getInstance().getResourceManager().getResource(res);
        if (resourceOptional.isPresent()) {
            Resource resource = (Resource)resourceOptional.get();
            try {
                ret = (LDLMetadataSection)resource.metadata().getSection((MetadataSectionSerializer)Serializer.INSTANCE).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        METADATA_CACHE.put(res, ret);
        return ret;
    }

    @Nonnull
    public static LDLMetadataSection getMetadata(TextureAtlasSprite sprite) {
        return LDLMetadataSection.getMetadata(LDLMetadataSection.spriteToAbsolute(sprite.contents().name()));
    }

    public static boolean isEmissive(TextureAtlasSprite sprite) {
        LDLMetadataSection ret = LDLMetadataSection.getMetadata(LDLMetadataSection.spriteToAbsolute(sprite.contents().name()));
        return ret.emissive;
    }

    @Nullable
    public static TextureAtlasSprite getConnection(TextureAtlasSprite sprite) {
        LDLMetadataSection ret = LDLMetadataSection.getMetadata(LDLMetadataSection.spriteToAbsolute(sprite.contents().name()));
        return ret.connection == null ? null : ModelFactory.getBlockSprite(ret.connection);
    }

    public static ResourceLocation spriteToAbsolute(ResourceLocation sprite) {
        if (!sprite.getPath().startsWith("textures/")) {
            sprite = new ResourceLocation(sprite.getNamespace(), "textures/" + sprite.getPath());
        }
        if (!sprite.getPath().endsWith(".png")) {
            sprite = new ResourceLocation(sprite.getNamespace(), sprite.getPath() + ".png");
        }
        return sprite;
    }

    public static class Serializer
    implements MetadataSectionSerializer<LDLMetadataSection> {
        static Serializer INSTANCE = new Serializer();

        @Nonnull
        public String getMetadataSectionName() {
            return LDLMetadataSection.SECTION_NAME;
        }

        @Nonnull
        public LDLMetadataSection fromJson(@Nonnull JsonObject json) {
            boolean emissive = false;
            ResourceLocation connection = null;
            if (json.isJsonObject()) {
                JsonElement element;
                JsonObject obj = json.getAsJsonObject();
                if (obj.has("emissive") && (element = obj.get("emissive")).isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
                    emissive = element.getAsBoolean();
                }
                if (obj.has("connection") && (element = obj.get("connection")).isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    connection = new ResourceLocation(element.getAsString());
                }
            }
            return new LDLMetadataSection(emissive, connection);
        }
    }
}

