/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.renderer.impl;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.FacadeBlockWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockStateRenderer
implements ISerializableRenderer {
    protected BlockInfo blockInfo;
    @OnlyIn(value=Dist.CLIENT)
    private BakedModel itemModel;

    protected BlockStateRenderer() {
        this.blockInfo = null;
    }

    public BlockStateRenderer(BlockState state) {
        this(BlockInfo.fromBlockState(state == null ? Blocks.BARRIER.defaultBlockState() : state));
    }

    public BlockStateRenderer(BlockInfo blockInfo) {
        BlockInfo blockInfo2 = this.blockInfo = blockInfo == null ? new BlockInfo(Blocks.BARRIER) : blockInfo;
        if (LDLib.isClient()) {
            this.registerEvent();
        }
    }

    public BlockState getState(@Nullable BlockState blockState) {
        BlockState state = this.getBlockInfo().getBlockState();
        if (blockState == null) {
            return state;
        }
        Direction facing = Direction.NORTH;
        if (blockState.hasProperty((Property)BlockStateProperties.FACING)) {
            facing = (Direction)blockState.getValue((Property)BlockStateProperties.FACING);
        } else if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            facing = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }
        try {
            switch (facing) {
                case EAST: {
                    state = state.rotate(Rotation.CLOCKWISE_90);
                    break;
                }
                case WEST: {
                    state = state.rotate(Rotation.COUNTERCLOCKWISE_90);
                    break;
                }
                case SOUTH: {
                    state = state.rotate(Rotation.CLOCKWISE_180);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected BakedModel getItemModel(ItemStack renderItem) {
        if (this.itemModel == null) {
            this.itemModel = Minecraft.getInstance().getItemRenderer().getModel(renderItem, null, null, 0);
        }
        return this.itemModel;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        ItemStack renderItem = this.getBlockInfo().getItemStackForm();
        BakedModel model = this.getItemModel(renderItem);
        if (model == null) {
            return ISerializableRenderer.super.getParticleTexture();
        }
        return model.getParticleIcon();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack renderItem = this.getBlockInfo().getItemStackForm();
        itemRenderer.render(renderItem, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, this.getItemModel(renderItem));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useBlockLight(ItemStack stack) {
        ItemStack renderItem = this.getBlockInfo().getItemStackForm();
        BakedModel model = this.getItemModel(renderItem);
        if (model != null) {
            return model.usesBlockLight();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> renderModel(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        if ((state = this.getState(state)).getRenderShape() != RenderShape.INVISIBLE) {
            BlockRenderDispatcher brd = Minecraft.getInstance().getBlockRenderer();
            BakedModel model = brd.getBlockModel(state);
            return model.getQuads(state, side, rand);
        }
        return Collections.emptyList();
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public BlockEntity getBlockEntity(BlockAndTintGetter world, BlockPos pos) {
        BlockInfo blockInfo = this.getBlockInfo();
        BlockEntity tile = blockInfo.getBlockEntity(pos);
        if (tile != null && world instanceof Level) {
            try {
                BlockState state = this.getState(world.getBlockState(pos));
                tile.setBlockState(state);
                tile.setLevel((Level)new FacadeBlockWorld((Level)world, pos, state, tile));
            }
            catch (Throwable throwable) {
                blockInfo.setHasBlockEntity(false);
            }
        }
        return tile;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity tileEntity) {
        if (!this.getBlockInfo().getBlockState().getFluidState().isEmpty()) {
            return true;
        }
        if ((tileEntity = this.getBlockEntity((BlockAndTintGetter)tileEntity.getLevel(), tileEntity.getBlockPos())) == null) {
            return false;
        }
        return Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(tileEntity) != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity tileEntity) {
        if ((tileEntity = this.getBlockEntity((BlockAndTintGetter)tileEntity.getLevel(), tileEntity.getBlockPos())) == null) {
            return false;
        }
        BlockEntityRenderer tesr = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(tileEntity);
        if (tesr != null) {
            return tesr.shouldRenderOffScreen(tileEntity);
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity tileEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockInfo block = this.getBlockInfo();
        FluidState fluidState = block.getBlockState().getFluidState();
        if (!fluidState.isEmpty()) {
            VertexConsumer builder = buffer.getBuffer(RenderType.translucent());
            Minecraft.getInstance().getBlockRenderer().renderLiquid(tileEntity.getBlockPos(), (BlockAndTintGetter)tileEntity.getLevel(), builder, block.getBlockState(), fluidState);
        }
        if ((tileEntity = this.getBlockEntity((BlockAndTintGetter)tileEntity.getLevel(), tileEntity.getBlockPos())) == null) {
            return;
        }
        BlockEntityRenderer tesr = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(tileEntity);
        if (tesr != null) {
            try {
                tesr.render(tileEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
            }
            catch (Exception e) {
                this.getBlockInfo().setHasBlockEntity(false);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        if (atlasName.equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            this.itemModel = null;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useAO() {
        BlockState state = this.getBlockInfo().getBlockState();
        if (state.getRenderShape() != RenderShape.INVISIBLE) {
            return Minecraft.getInstance().getBlockRenderer().getBlockModel(state).useAmbientOcclusion();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isGui3d() {
        BakedModel model = this.getItemModel(this.getBlockInfo().getItemStackForm());
        if (model == null) {
            return ISerializableRenderer.super.isGui3d();
        }
        return model.isGui3d();
    }

    public BlockInfo getBlockInfo() {
        return this.blockInfo;
    }
}

