/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.scene;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class FBOWorldSceneRenderer
extends WorldSceneRenderer {
    private int resolutionWidth = 1080;
    private int resolutionHeight = 1080;
    private RenderTarget fbo;

    public FBOWorldSceneRenderer(Level world, int resolutionWidth, int resolutionHeight) {
        super(world);
        this.setFBOSize(resolutionWidth, resolutionHeight);
    }

    public FBOWorldSceneRenderer(Level world, RenderTarget fbo) {
        super(world);
        this.fbo = fbo;
    }

    public int getResolutionWidth() {
        return this.resolutionWidth;
    }

    public int getResolutionHeight() {
        return this.resolutionHeight;
    }

    public void setFBOSize(int resolutionWidth, int resolutionHeight) {
        this.resolutionWidth = resolutionWidth;
        this.resolutionHeight = resolutionHeight;
        this.releaseFBO();
        try {
            this.fbo = new MainTarget(resolutionWidth, resolutionHeight);
        }
        catch (Exception e) {
            LDLib.LOGGER.error("set FBO SIZE failed", (Throwable)e);
        }
    }

    public BlockHitResult screenPos2BlockPosFace(int mouseX, int mouseY) {
        int lastID = this.bindFBO();
        BlockHitResult looking = super.screenPos2BlockPosFace(mouseX, mouseY, 0, 0, this.resolutionWidth, this.resolutionHeight);
        this.unbindFBO(lastID);
        return looking;
    }

    public Vector3f blockPos2ScreenPos(BlockPos pos, boolean depth) {
        int lastID = this.bindFBO();
        Vector3f winPos = super.blockPos2ScreenPos(pos, depth, 0, 0, this.resolutionWidth, this.resolutionHeight);
        this.unbindFBO(lastID);
        return winPos;
    }

    public void render(@Nonnull PoseStack poseStack, float x, float y, float width, float height, float mouseX, float mouseY) {
        int lastID = this.bindFBO();
        super.render(new PoseStack(), 0.0f, 0.0f, this.resolutionWidth, this.resolutionHeight, (int)((float)this.resolutionWidth * (mouseX - x) / width), (int)((float)this.resolutionHeight * (1.0f - (mouseY - y) / height)));
        this.unbindFBO(lastID);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (int)this.fbo.getColorTextureId());
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f pose = poseStack.last().pose();
        bufferbuilder.vertex(pose, x + width, y + height, 0.0f).uv(1.0f, 0.0f).endVertex();
        bufferbuilder.vertex(pose, x + width, y, 0.0f).uv(1.0f, 1.0f).endVertex();
        bufferbuilder.vertex(pose, x, y, 0.0f).uv(0.0f, 1.0f).endVertex();
        bufferbuilder.vertex(pose, x, y + height, 0.0f).uv(0.0f, 0.0f).endVertex();
        tessellator.end();
    }

    @Override
    public void render(@Nonnull PoseStack poseStack, float x, float y, float width, float height, int mouseX, int mouseY) {
        this.render(poseStack, x, y, width, height, (float)mouseX, (float)mouseY);
    }

    private int bindFBO() {
        int lastID = GL11.glGetInteger((int)36006);
        this.fbo.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.fbo.clear(Minecraft.ON_OSX);
        this.fbo.bindWrite(true);
        return lastID;
    }

    private void unbindFBO(int lastID) {
        this.fbo.unbindRead();
        GlStateManager._glBindFramebuffer((int)36160, (int)lastID);
    }

    public void releaseFBO() {
        if (this.fbo != null) {
            this.fbo.destroyBuffers();
        }
        this.fbo = null;
    }
}

