/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.scene;

import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.lowdragmc.lowdraglib.utils.PositionedRect;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class ImmediateWorldSceneRenderer
extends WorldSceneRenderer {
    public ImmediateWorldSceneRenderer(Level world) {
        super(world);
    }

    @Override
    public PositionedRect getPositionedRect(int x, int y, int width, int height) {
        Window window = Minecraft.getInstance().getWindow();
        int windowWidth = (int)((double)width / ((double)window.getGuiScaledWidth() * 1.0) * (double)window.getWidth());
        int windowHeight = (int)((double)height / ((double)window.getGuiScaledHeight() * 1.0) * (double)window.getHeight());
        int windowX = (int)((double)x / ((double)window.getGuiScaledWidth() * 1.0) * (double)window.getWidth());
        int windowY = window.getHeight() - (int)((double)y / ((double)window.getGuiScaledHeight() * 1.0) * (double)window.getHeight()) - windowHeight;
        return super.getPositionedRect(windowX, windowY, windowWidth, windowHeight);
    }

    @Override
    public PositionedRect getPositionRectRevert(int windowX, int windowY, int windowWidth, int windowHeight) {
        Window window = Minecraft.getInstance().getWindow();
        int width = windowWidth * window.getGuiScaledWidth() / window.getWidth();
        int height = windowHeight * window.getGuiScaledHeight() / window.getHeight();
        int x = windowX * window.getGuiScaledWidth() / window.getWidth();
        int y = (window.getHeight() - windowY - windowHeight) * window.getGuiScaledHeight() / window.getHeight();
        return super.getPositionRectRevert(x, y, width, height);
    }

    @Override
    protected void clearView(int x, int y, int width, int height) {
        int a = (this.clearColor & 0xFF000000) >> 24;
        if (a == 0) {
            RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
            return;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
        super.clearView(x, y, width, height);
        GL11.glDisable((int)3089);
    }
}

