/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.scene;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleManager {
    private static final List<ParticleRenderType> RENDER_ORDER = ImmutableList.of((Object)ParticleRenderType.TERRAIN_SHEET, (Object)ParticleRenderType.PARTICLE_SHEET_OPAQUE, (Object)ParticleRenderType.PARTICLE_SHEET_LIT, (Object)ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT, (Object)ParticleRenderType.CUSTOM);
    private final Queue<Particle> waitToAdded = Queues.newArrayDeque();
    private final Map<ParticleRenderType, Queue<Particle>> particles = Maps.newTreeMap(ParticleManager.makeParticleRenderTypeComparator(RENDER_ORDER));
    private final TextureManager textureManager = Minecraft.getInstance().getTextureManager();
    public Level level;

    public void setLevel(Level level) {
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllParticles() {
        Queue<Particle> queue = this.waitToAdded;
        synchronized (queue) {
            this.waitToAdded.clear();
            this.particles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticle(Particle particle) {
        Queue<Particle> queue = this.waitToAdded;
        synchronized (queue) {
            this.waitToAdded.add(particle);
        }
    }

    public int getParticleAmount() {
        int amount = this.waitToAdded.size();
        return amount += this.particles.values().stream().mapToInt(Collection::size).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (!this.waitToAdded.isEmpty()) {
            Queue<Particle> queue = this.waitToAdded;
            synchronized (queue) {
                for (Particle particle : this.waitToAdded) {
                    this.particles.computeIfAbsent(particle.getRenderType(), type -> Queues.newArrayDeque()).add(particle);
                }
                this.waitToAdded.clear();
            }
        }
        this.particles.forEach((particleRenderType, particleQueue) -> this.tickParticleList((Collection<Particle>)particleQueue));
    }

    private void tickParticleList(Collection<Particle> pParticles) {
        if (!pParticles.isEmpty()) {
            Iterator<Particle> iterator = pParticles.iterator();
            while (iterator.hasNext()) {
                Particle particle = iterator.next();
                particle.tick();
                if (particle.isAlive()) continue;
                iterator.remove();
            }
        }
    }

    public void render(PoseStack pMatrixStack, Camera pActiveRenderInfo, float pPartialTicks) {
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        RenderSystem.enableDepthTest();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.pushPose();
        posestack.mulPoseMatrix(pMatrixStack.last().pose());
        RenderSystem.applyModelViewMatrix();
        for (ParticleRenderType particlerendertype : this.particles.keySet()) {
            Queue<Particle> iterable;
            if (particlerendertype == ParticleRenderType.NO_RENDER || (iterable = this.particles.get(particlerendertype)) == null) continue;
            RenderSystem.setShader(GameRenderer::getParticleShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = tesselator.getBuilder();
            particlerendertype.begin(bufferbuilder, this.textureManager);
            for (Particle particle : iterable) {
                particle.render((VertexConsumer)bufferbuilder, pActiveRenderInfo, pPartialTicks);
            }
            particlerendertype.end(tesselator);
        }
        posestack.popPose();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        Minecraft.getInstance().gameRenderer.lightTexture().turnOffLightLayer();
    }

    public static Comparator<ParticleRenderType> makeParticleRenderTypeComparator(List<ParticleRenderType> renderOrder) {
        Comparator<ParticleRenderType> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((ParticleRenderType)typeOne, (ParticleRenderType)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            return vanillaOne ? -1 : 1;
        };
    }
}

