/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.scene;

import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.scene.CameraEntity;
import com.lowdragmc.lowdraglib.client.scene.ISceneBlockRenderHook;
import com.lowdragmc.lowdraglib.client.scene.ISceneEntityRenderHook;
import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import com.lowdragmc.lowdraglib.client.scene.forge.WorldSceneRendererImpl;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderManager;
import com.lowdragmc.lowdraglib.client.utils.glu.Project;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.PositionedRect;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public abstract class WorldSceneRenderer {
    protected static final FloatBuffer MODELVIEW_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final FloatBuffer PROJECTION_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final IntBuffer VIEWPORT_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
    protected static final FloatBuffer PIXEL_DEPTH_BUFFER = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final FloatBuffer OBJECT_POS_BUFFER = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();
    public final Level world;
    public final Map<Collection<BlockPos>, ISceneBlockRenderHook> renderedBlocksMap;
    protected VertexBuffer[] vertexBuffers;
    protected Set<BlockPos> tileEntities;
    protected boolean useCache;
    protected boolean endBatchLast = false;
    protected boolean ortho;
    protected AtomicReference<CacheState> cacheState;
    protected int maxProgress;
    protected int progress;
    protected Thread thread;
    protected ParticleManager particleManager;
    protected Camera camera;
    protected CameraEntity cameraEntity;
    private Consumer<WorldSceneRenderer> beforeRender;
    private Consumer<WorldSceneRenderer> afterRender;
    @Nullable
    private BiConsumer<MultiBufferSource, Float> beforeBatchEnd;
    private Consumer<BlockHitResult> onLookingAt;
    @Nullable
    private ISceneEntityRenderHook sceneEntityRenderHook;
    protected int clearColor;
    private Vector3f lastHit;
    private BlockHitResult lastTraceResult;
    private Set<BlockPos> blocked;
    private Vector3f eyePos = new Vector3f(0.0f, 0.0f, 10.0f);
    private Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f worldUp = new Vector3f(0.0f, 1.0f, 0.0f);
    private float fov = 60.0f;
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;
    private float minZ;
    private float maxZ;

    public WorldSceneRenderer(Level world) {
        this.world = world;
        this.renderedBlocksMap = new LinkedHashMap<Collection<BlockPos>, ISceneBlockRenderHook>();
        this.cacheState = new AtomicReference<CacheState>(CacheState.UNUSED);
    }

    public WorldSceneRenderer setParticleManager(ParticleManager particleManager) {
        if (particleManager == null) {
            this.particleManager = null;
            this.camera = null;
            this.cameraEntity = null;
            return this;
        }
        this.particleManager = particleManager;
        Level level = this.world;
        if (level instanceof DummyWorld) {
            DummyWorld dummyWorld = (DummyWorld)level;
            dummyWorld.setParticleManager(particleManager);
        }
        this.particleManager.setLevel(this.world);
        this.camera = new Camera();
        this.cameraEntity = new CameraEntity(this.world);
        this.setCameraLookAt(this.eyePos, this.lookAt, this.worldUp);
        return this;
    }

    public ParticleManager getParticleManager() {
        return this.particleManager;
    }

    public WorldSceneRenderer useCacheBuffer(boolean useCache) {
        if (this.useCache || !Minecraft.getInstance().isSameThread()) {
            return this;
        }
        this.deleteCacheBuffer();
        if (useCache) {
            List layers = RenderType.chunkBufferLayers();
            this.vertexBuffers = new VertexBuffer[layers.size()];
            for (int j = 0; j < layers.size(); ++j) {
                this.vertexBuffers[j] = new VertexBuffer(VertexBuffer.Usage.STATIC);
            }
            if (this.cacheState.get() == CacheState.COMPILING && this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
            this.cacheState.set(CacheState.NEED);
        }
        this.useCache = useCache;
        return this;
    }

    public WorldSceneRenderer useOrtho(boolean ortho) {
        this.ortho = ortho;
        return this;
    }

    public WorldSceneRenderer deleteCacheBuffer() {
        if (this.useCache) {
            for (int i = 0; i < RenderType.chunkBufferLayers().size(); ++i) {
                if (this.vertexBuffers[i] == null) continue;
                this.vertexBuffers[i].close();
            }
            if (this.cacheState.get() == CacheState.COMPILING && this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
        }
        this.tileEntities = null;
        this.useCache = false;
        this.cacheState.set(CacheState.UNUSED);
        return this;
    }

    public WorldSceneRenderer needCompileCache() {
        if (this.cacheState.get() == CacheState.COMPILING && this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.cacheState.set(CacheState.NEED);
        return this;
    }

    public WorldSceneRenderer setBeforeWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.beforeRender = callback;
        return this;
    }

    public WorldSceneRenderer setAfterWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.afterRender = callback;
        return this;
    }

    public WorldSceneRenderer addRenderedBlocks(Collection<BlockPos> blocks, ISceneBlockRenderHook renderHook) {
        if (blocks != null) {
            this.renderedBlocksMap.put(blocks, renderHook);
        }
        return this;
    }

    public WorldSceneRenderer setBlocked(Set<BlockPos> blocked) {
        this.blocked = blocked;
        return this;
    }

    public WorldSceneRenderer setOnLookingAt(Consumer<BlockHitResult> onLookingAt) {
        this.onLookingAt = onLookingAt;
        return this;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setClearColor(int clearColor) {
        this.clearColor = clearColor;
    }

    public void render(@Nonnull PoseStack poseStack, float x, float y, float width, float height, int mouseX, int mouseY) {
        BlockHitResult result;
        if (Minecraft.getInstance().getOverlay() instanceof LoadingOverlay) {
            return;
        }
        Matrix4f pose = poseStack.last().pose();
        Vector4f pos = new Vector4f(x, y, 0.0f, 1.0f);
        pos = pose.transform(pos);
        Vector4f size = new Vector4f(x + width, y + height, 0.0f, 1.0f);
        size = pose.transform(size);
        x = pos.x();
        y = pos.y();
        width = size.x() - x;
        height = size.y() - y;
        PositionedRect viewport = this.getPositionedRect((int)x, (int)y, (int)width, (int)height);
        Vector3f topLeft = poseStack.last().pose().transformPosition(new Vector3f(0.0f, 0.0f, 0.0f));
        PositionedRect mouse = this.getPositionedRect((int)((float)mouseX + topLeft.x), (int)((float)mouseY + topLeft.y), 0, 0);
        mouseX = mouse.position.x;
        mouseY = mouse.position.y;
        this.setupCamera(viewport);
        this.drawWorld();
        this.lastTraceResult = null;
        this.lastHit = this.unProject(mouseX, mouseY);
        if (this.onLookingAt != null && mouseX > viewport.position.x && mouseX < viewport.position.x + viewport.size.width && mouseY > viewport.position.y && mouseY < viewport.position.y + viewport.size.height && (result = this.rayTrace(this.lastHit)) != null) {
            this.lastTraceResult = null;
            this.lastTraceResult = result;
            this.onLookingAt.accept(result);
        }
        this.resetCamera();
    }

    public Vector3f getEyePos() {
        return this.eyePos;
    }

    public Vector3f getLookAt() {
        return this.lookAt;
    }

    public Vector3f getWorldUp() {
        return this.worldUp;
    }

    public void setCameraLookAt(Vector3f eyePos, Vector3f lookAt, Vector3f worldUp) {
        this.eyePos = eyePos;
        this.lookAt = lookAt;
        this.worldUp = worldUp;
        if (this.camera != null) {
            Vector3f xzProduct = new Vector3f(lookAt.x() - eyePos.x(), 0.0f, lookAt.z() - eyePos.z());
            double angleYaw = Math.toDegrees(xzProduct.angle((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
            Vector3f vector3f = new Vector3f(1.0f, 0.0f, 0.0f);
            if ((double)xzProduct.angle((Vector3fc)vector3f) < 1.5707963267948966) {
                angleYaw = -angleYaw;
            }
            double anglePitch = Math.toDegrees(new Vector3f((Vector3fc)lookAt).sub((Vector3fc)new Vector3f((Vector3fc)eyePos)).angle((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f))) - 90.0;
            this.cameraEntity.setPos(eyePos.x(), eyePos.y() - this.cameraEntity.getEyeHeight(), eyePos.z());
            this.cameraEntity.xo = this.cameraEntity.getX();
            this.cameraEntity.yo = this.cameraEntity.getY();
            this.cameraEntity.zo = this.cameraEntity.getZ();
            this.cameraEntity.setYRot((float)angleYaw);
            this.cameraEntity.setXRot((float)anglePitch);
            this.cameraEntity.yRotO = this.cameraEntity.getYRot();
            this.cameraEntity.xRotO = this.cameraEntity.getXRot();
        }
    }

    public void setCameraLookAt(Vector3f lookAt, double radius, double rotationPitch, double rotationYaw) {
        Vector3f vecX = new Vector3f((float)Math.cos(rotationPitch), 0.0f, (float)Math.sin(rotationPitch));
        Vector3f vecY = new Vector3f(0.0f, (float)(Math.tan(rotationYaw) * (double)vecX.length()), 0.0f);
        Vector3f pos = new Vector3f((Vector3fc)vecX).add((Vector3fc)vecY).normalize().mul((float)radius);
        this.setCameraLookAt(pos.add(lookAt.x(), lookAt.y(), lookAt.z()), lookAt, this.worldUp);
    }

    public void setFov(float fov) {
        this.fov = fov;
    }

    public void setCameraOrtho(float x, float y, float z) {
        this.minX = -x;
        this.maxX = x;
        this.minY = -y;
        this.maxY = y;
        this.minZ = -z;
        this.maxZ = z;
    }

    public void setCameraOrtho(float minX, float maxX, float minY, float maxY, float minZ, float maxZ) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
    }

    public PositionedRect getPositionedRect(int x, int y, int width, int height) {
        return new PositionedRect(new Position(x, y), new Size(width, height));
    }

    public PositionedRect getPositionRectRevert(int windowX, int windowY, int windowWidth, int windowHeight) {
        return new PositionedRect(new Position(windowX, windowY), new Size(windowWidth, windowHeight));
    }

    protected void setupCamera(PositionedRect viewport) {
        int x = viewport.getPosition().x;
        int y = viewport.getPosition().y;
        int width = viewport.getSize().width;
        int height = viewport.getSize().height;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.viewport((int)x, (int)y, (int)width, (int)height);
        RenderSystem.depthMask((boolean)true);
        this.clearView(x, y, width, height);
        RenderSystem.backupProjectionMatrix();
        float aspectRatio = (float)width / ((float)height * 1.0f);
        if (this.ortho) {
            RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(this.minX, this.maxX, this.minY / aspectRatio, this.maxY / aspectRatio, this.minZ, this.maxZ), (VertexSorting)VertexSorting.byDistance((Vector3f)this.camera.getPosition().toVector3f()));
        } else {
            RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setPerspective(this.fov * ((float)Math.PI / 180), aspectRatio, 0.1f, 10000.0f), (VertexSorting)VertexSorting.byDistance((Vector3f)this.camera.getPosition().toVector3f()));
        }
        PoseStack posesStack = RenderSystem.getModelViewStack();
        posesStack.pushPose();
        posesStack.setIdentity();
        Project.gluLookAt(posesStack, this.eyePos.x(), this.eyePos.y(), this.eyePos.z(), this.lookAt.x(), this.lookAt.y(), this.lookAt.z(), this.worldUp.x(), this.worldUp.y(), this.worldUp.z());
        RenderSystem.applyModelViewMatrix();
        RenderSystem.activeTexture((int)33984);
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.enableCull();
        if (this.camera != null) {
            this.camera.setup((BlockGetter)this.world, (Entity)this.cameraEntity, false, false, mc.getFrameTime());
        }
        ShaderManager.getInstance().setViewPort(viewport);
    }

    protected void clearView(int x, int y, int width, int height) {
        int i = (this.clearColor & 0xFF0000) >> 16;
        int j = (this.clearColor & 0xFF00) >> 8;
        int k = this.clearColor & 0xFF;
        RenderSystem.clearColor((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)(this.clearColor >> 24) / 255.0f));
        RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
    }

    protected void resetCamera() {
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.viewport((int)0, (int)0, (int)minecraft.getWindow().getWidth(), (int)minecraft.getWindow().getHeight());
        RenderSystem.restoreProjectionMatrix();
        PoseStack posesStack = RenderSystem.getModelViewStack();
        posesStack.popPose();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        ShaderManager.getInstance().clearViewPort();
    }

    protected void drawWorld() {
        if (this.beforeRender != null) {
            this.beforeRender.accept(this);
        }
        Minecraft mc = Minecraft.getInstance();
        float particleTicks = mc.getFrameTime();
        MultiBufferSource.BufferSource buffers = mc.renderBuffers().bufferSource();
        if (this.useCache) {
            this.renderCacheBuffer(mc, buffers, particleTicks);
        } else {
            BlockRenderDispatcher blockrendererdispatcher = mc.getBlockRenderer();
            this.renderedBlocksMap.forEach((renderedBlocks, hook) -> {
                for (RenderType layer : RenderType.chunkBufferLayers()) {
                    layer.setupRenderState();
                    Random random = new Random();
                    PoseStack poseStack = new PoseStack();
                    if (layer == RenderType.translucent()) {
                        if (hook != null) {
                            hook.apply(true, layer);
                        } else {
                            WorldSceneRenderer.setDefaultRenderLayerState(null);
                        }
                        this.renderTESR((Collection<BlockPos>)renderedBlocks, poseStack, buffers, (ISceneBlockRenderHook)hook, particleTicks);
                        if (hook != null || !this.endBatchLast) {
                            buffers.endBatch();
                        }
                    }
                    if (hook != null) {
                        hook.apply(false, layer);
                    } else {
                        WorldSceneRenderer.setDefaultRenderLayerState(layer);
                    }
                    VertexConsumer buffer = buffers.getBuffer(layer);
                    this.renderBlocks(poseStack, blockrendererdispatcher, layer, new VertexConsumerWrapper(buffer), (Collection<BlockPos>)renderedBlocks, (ISceneBlockRenderHook)hook, particleTicks);
                    if (!this.endBatchLast) {
                        buffers.endBatch();
                    }
                    layer.clearRenderState();
                }
            });
        }
        Level level = this.world;
        if (level instanceof TrackedDummyWorld) {
            TrackedDummyWorld level2 = (TrackedDummyWorld)level;
            PoseStack poseStack = new PoseStack();
            this.renderEntities(level2, poseStack, (MultiBufferSource)buffers, this.sceneEntityRenderHook, particleTicks);
        }
        if (this.beforeBatchEnd != null) {
            this.beforeBatchEnd.accept((MultiBufferSource)buffers, Float.valueOf(particleTicks));
        }
        buffers.endBatch();
        if (this.particleManager != null) {
            PoseStack poseStack = new PoseStack();
            poseStack.setIdentity();
            poseStack.translate(this.cameraEntity.getX(), this.cameraEntity.getY(), this.cameraEntity.getZ());
            this.particleManager.render(poseStack, this.camera, particleTicks);
        }
        if (this.afterRender != null) {
            this.afterRender.accept(this);
        }
    }

    public boolean isCompiling() {
        return this.cacheState.get() == CacheState.COMPILING;
    }

    public double getCompileProgress() {
        if (this.maxProgress > 1000) {
            return (double)this.progress * 1.0 / (double)this.maxProgress;
        }
        return 0.0;
    }

    private void renderCacheBuffer(Minecraft mc, MultiBufferSource.BufferSource buffers, float particleTicks) {
        List layers = RenderType.chunkBufferLayers();
        if (this.cacheState.get() == CacheState.NEED) {
            this.progress = 0;
            this.maxProgress = this.renderedBlocksMap.keySet().stream().map(Collection::size).reduce(0, Integer::sum) * (layers.size() + 1);
            this.thread = new Thread(() -> {
                this.cacheState.set(CacheState.COMPILING);
                BlockRenderDispatcher blockrendererdispatcher = mc.getBlockRenderer();
                ModelBlockRenderer.enableCaching();
                PoseStack matrixstack = new PoseStack();
                for (int i = 0; i < layers.size(); ++i) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    RenderType layer = (RenderType)layers.get(i);
                    BufferBuilder buffer = new BufferBuilder(layer.bufferSize());
                    buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
                    this.renderedBlocksMap.forEach((renderedBlocks, hook) -> this.renderBlocks(matrixstack, blockrendererdispatcher, layer, new VertexConsumerWrapper((VertexConsumer)buffer), (Collection<BlockPos>)renderedBlocks, (ISceneBlockRenderHook)hook, 0.0f));
                    BufferBuilder.RenderedBuffer builder = buffer.end();
                    VertexBuffer vertexBuffer = this.vertexBuffers[i];
                    Runnable toUpload = () -> {
                        if (!vertexBuffer.isInvalid()) {
                            vertexBuffer.bind();
                            vertexBuffer.upload(builder);
                            VertexBuffer.unbind();
                        }
                    };
                    CompletableFuture.runAsync(toUpload, runnable -> RenderSystem.recordRenderCall(runnable::run));
                }
                ModelBlockRenderer.clearCache();
                HashSet<BlockPos> poses = new HashSet<BlockPos>();
                this.renderedBlocksMap.forEach((renderedBlocks, hook) -> {
                    for (BlockPos pos : renderedBlocks) {
                        ++this.progress;
                        if (Thread.interrupted()) {
                            return;
                        }
                        BlockEntity tile = this.world.getBlockEntity(pos);
                        if (tile == null || mc.getBlockEntityRenderDispatcher().getRenderer(tile) == null) continue;
                        poses.add(pos);
                    }
                });
                if (Thread.interrupted()) {
                    return;
                }
                this.tileEntities = poses;
                this.cacheState.set(CacheState.COMPILED);
                this.thread = null;
                this.maxProgress = -1;
            });
            this.thread.start();
        } else {
            PoseStack matrixstack = new PoseStack();
            for (int i = 0; i < layers.size(); ++i) {
                VertexBuffer vertexbuffer = this.vertexBuffers[i];
                if (vertexbuffer.isInvalid() || vertexbuffer.getFormat() == null) continue;
                RenderType layer = (RenderType)layers.get(i);
                if (layer == RenderType.translucent() && this.tileEntities != null) {
                    Level level = this.world;
                    if (level instanceof TrackedDummyWorld) {
                        TrackedDummyWorld level2 = (TrackedDummyWorld)level;
                        this.renderEntities(level2, matrixstack, (MultiBufferSource)buffers, this.sceneEntityRenderHook, particleTicks);
                    }
                    this.renderTESR(this.tileEntities, matrixstack, mc.renderBuffers().bufferSource(), null, particleTicks);
                    if (!this.endBatchLast) {
                        buffers.endBatch();
                    }
                }
                layer.setupRenderState();
                matrixstack.pushPose();
                ShaderInstance shaderInstance = RenderSystem.getShader();
                for (int j = 0; j < 12; ++j) {
                    int k = RenderSystem.getShaderTexture((int)j);
                    shaderInstance.setSampler("Sampler" + j, (Object)k);
                }
                if (shaderInstance.MODEL_VIEW_MATRIX != null) {
                    shaderInstance.MODEL_VIEW_MATRIX.set(RenderSystem.getModelViewMatrix());
                }
                if (shaderInstance.PROJECTION_MATRIX != null) {
                    shaderInstance.PROJECTION_MATRIX.set(RenderSystem.getProjectionMatrix());
                }
                if (shaderInstance.COLOR_MODULATOR != null) {
                    shaderInstance.COLOR_MODULATOR.set(RenderSystem.getShaderColor());
                }
                if (shaderInstance.FOG_START != null) {
                    shaderInstance.FOG_START.set(RenderSystem.getShaderFogStart());
                }
                if (shaderInstance.FOG_END != null) {
                    shaderInstance.FOG_END.set(RenderSystem.getShaderFogEnd());
                }
                if (shaderInstance.FOG_COLOR != null) {
                    shaderInstance.FOG_COLOR.set(RenderSystem.getShaderFogColor());
                }
                if (shaderInstance.FOG_SHAPE != null) {
                    shaderInstance.FOG_SHAPE.set(RenderSystem.getShaderFogShape().getIndex());
                }
                if (shaderInstance.TEXTURE_MATRIX != null) {
                    shaderInstance.TEXTURE_MATRIX.set(RenderSystem.getTextureMatrix());
                }
                if (shaderInstance.GAME_TIME != null) {
                    shaderInstance.GAME_TIME.set(RenderSystem.getShaderGameTime());
                }
                RenderSystem.setupShaderLights((ShaderInstance)shaderInstance);
                shaderInstance.apply();
                WorldSceneRenderer.setDefaultRenderLayerState(layer);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                vertexbuffer.bind();
                vertexbuffer.draw();
                matrixstack.popPose();
                shaderInstance.clear();
                VertexBuffer.unbind();
                layer.clearRenderState();
            }
        }
    }

    private void renderBlocks(PoseStack poseStack, BlockRenderDispatcher blockrendererdispatcher, RenderType layer, VertexConsumerWrapper wrapperBuffer, Collection<BlockPos> renderedBlocks, @Nullable ISceneBlockRenderHook hook, float partialTicks) {
        for (BlockPos pos : renderedBlocks) {
            if (this.blocked != null && this.blocked.contains(pos)) continue;
            BlockState state = this.world.getBlockState(pos);
            FluidState fluidState = state.getFluidState();
            Block block = state.getBlock();
            BlockEntity te = this.world.getBlockEntity(pos);
            if (hook != null) {
                hook.applyVertexConsumerWrapper(this.world, pos, state, wrapperBuffer, layer, partialTicks);
            }
            if (block == Blocks.AIR) continue;
            if (state.getRenderShape() != RenderShape.INVISIBLE && WorldSceneRenderer.canRenderInLayer(state, layer)) {
                poseStack.pushPose();
                poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                if (Platform.isForge()) {
                    WorldSceneRenderer.renderBlocksForge(blockrendererdispatcher, state, pos, (BlockAndTintGetter)this.world, poseStack, wrapperBuffer, this.world.random, layer);
                } else {
                    blockrendererdispatcher.renderBatched(state, pos, (BlockAndTintGetter)this.world, poseStack, (VertexConsumer)wrapperBuffer, false, this.world.random);
                }
                poseStack.popPose();
            }
            if (!fluidState.isEmpty() && ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState) == layer) {
                wrapperBuffer.addOffset(pos.getX() - (pos.getX() & 0xF), pos.getY() - (pos.getY() & 0xF), pos.getZ() - (pos.getZ() & 0xF));
                blockrendererdispatcher.renderLiquid(pos, (BlockAndTintGetter)this.world, (VertexConsumer)wrapperBuffer, state, fluidState);
            }
            wrapperBuffer.clerOffset();
            wrapperBuffer.clearColor();
            if (this.maxProgress <= 0) continue;
            ++this.progress;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canRenderInLayer(BlockState state, RenderType renderType) {
        void var1_1;
        return WorldSceneRendererImpl.canRenderInLayer(state, (RenderType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @PlatformOnly(value={"forge"})
    @ExpectPlatform.Transformed
    public static void renderBlocksForge(BlockRenderDispatcher blockRenderDispatcher, BlockState state, BlockPos pos, BlockAndTintGetter level, @Nonnull PoseStack poseStack, VertexConsumer consumer, RandomSource random, RenderType renderType) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        WorldSceneRendererImpl.renderBlocksForge(blockRenderDispatcher, (BlockState)var1_1, (BlockPos)var2_2, (BlockAndTintGetter)var3_3, (PoseStack)var4_4, (VertexConsumer)var5_5, (RandomSource)var6_6, (RenderType)var7_7);
    }

    private void renderTESR(Collection<BlockPos> poses, PoseStack poseStack, MultiBufferSource.BufferSource buffers, @Nullable ISceneBlockRenderHook hook, float partialTicks) {
        for (BlockPos pos : poses) {
            BlockEntity tile = this.world.getBlockEntity(pos);
            if (tile == null) continue;
            poseStack.pushPose();
            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            BlockEntityRenderer tileentityrenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(tile);
            if (tileentityrenderer != null && tile.hasLevel() && tile.getType().isValid(tile.getBlockState())) {
                Level world = tile.getLevel();
                if (hook != null) {
                    hook.applyBESR(world, pos, tile, poseStack, partialTicks);
                }
                tileentityrenderer.render(tile, partialTicks, poseStack, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            poseStack.popPose();
        }
    }

    private void renderEntities(TrackedDummyWorld level, PoseStack poseStack, MultiBufferSource buffer, @Nullable ISceneEntityRenderHook hook, float partialTicks) {
        for (Entity entity : level.getAllEntities()) {
            poseStack.pushPose();
            if (entity.tickCount == 0) {
                entity.xOld = entity.getX();
                entity.yOld = entity.getY();
                entity.zOld = entity.getZ();
            }
            double d0 = Mth.lerp((double)partialTicks, (double)entity.xOld, (double)entity.getX());
            double d1 = Mth.lerp((double)partialTicks, (double)entity.yOld, (double)entity.getY());
            double d2 = Mth.lerp((double)partialTicks, (double)entity.zOld, (double)entity.getZ());
            float f = Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
            EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
            int light = renderManager.getRenderer(entity).getPackedLightCoords(entity, partialTicks);
            if (hook != null) {
                hook.applyEntity(this.world, entity, poseStack, partialTicks);
            }
            renderManager.render(entity, d0, d1, d2, f, partialTicks, poseStack, buffer, light);
            poseStack.popPose();
        }
    }

    public static void setDefaultRenderLayerState(RenderType layer) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (layer == RenderType.translucent()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.depthMask((boolean)false);
        } else {
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public BlockHitResult rayTrace(Vector3f hitPos) {
        Vec3 startPos = new Vec3((double)this.eyePos.x(), (double)this.eyePos.y(), (double)this.eyePos.z());
        if (this.ortho) {
            startPos = startPos.add(new Vec3(startPos.x - (double)this.lookAt.x(), startPos.y - (double)this.lookAt.y(), startPos.z - (double)this.lookAt.z()).multiply(500.0, 500.0, 500.0));
        }
        hitPos = hitPos.mul(2.0f, new Vector3f());
        Vec3 endPos = new Vec3((double)hitPos.x() - startPos.x, (double)hitPos.y() - startPos.y, (double)hitPos.z() - startPos.z);
        try {
            return this.world.clip(new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.cameraEntity));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Vector3f project(Vector3f pos) {
        RenderSystem.getModelViewMatrix().get(MODELVIEW_MATRIX_BUFFER);
        RenderSystem.getProjectionMatrix().get(PROJECTION_MATRIX_BUFFER);
        GL11.glGetIntegerv((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        Project.gluProject(pos.x(), pos.y(), pos.z(), MODELVIEW_MATRIX_BUFFER, PROJECTION_MATRIX_BUFFER, VIEWPORT_BUFFER, OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float winX = OBJECT_POS_BUFFER.get();
        float winY = OBJECT_POS_BUFFER.get();
        float winZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(winX, winY, winZ);
    }

    public Vector3f unProject(int mouseX, int mouseY) {
        return this.unProject(mouseX, mouseY, true);
    }

    public Vector3f unProject(int mouseX, int mouseY, boolean checkDepth) {
        float pixelDepth = 0.999f;
        if (checkDepth) {
            GL11.glReadPixels((int)mouseX, (int)mouseY, (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)PIXEL_DEPTH_BUFFER);
            PIXEL_DEPTH_BUFFER.rewind();
            pixelDepth = PIXEL_DEPTH_BUFFER.get();
        }
        PIXEL_DEPTH_BUFFER.rewind();
        RenderSystem.getModelViewMatrix().get(MODELVIEW_MATRIX_BUFFER);
        RenderSystem.getProjectionMatrix().get(PROJECTION_MATRIX_BUFFER);
        GL11.glGetIntegerv((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        Project.gluUnProject(mouseX, mouseY, pixelDepth, MODELVIEW_MATRIX_BUFFER, PROJECTION_MATRIX_BUFFER, VIEWPORT_BUFFER, OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float posX = OBJECT_POS_BUFFER.get();
        float posY = OBJECT_POS_BUFFER.get();
        float posZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(posX, posY, posZ);
    }

    protected BlockHitResult screenPos2BlockPosFace(int mouseX, int mouseY, int x, int y, int width, int height) {
        RenderSystem.enableDepthTest();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f hitPos = this.lastHit == null ? this.unProject(mouseX, mouseY) : this.lastHit;
        BlockHitResult result = this.rayTrace(hitPos);
        this.resetCamera();
        return result;
    }

    protected Vector3f blockPos2ScreenPos(BlockPos pos, boolean depth, int x, int y, int width, int height) {
        RenderSystem.enableDepthTest();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f winPos = this.project(new Vector3f((float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f));
        this.resetCamera();
        return winPos;
    }

    public boolean isEndBatchLast() {
        return this.endBatchLast;
    }

    public void setEndBatchLast(boolean endBatchLast) {
        this.endBatchLast = endBatchLast;
    }

    public void setBeforeBatchEnd(@Nullable BiConsumer<MultiBufferSource, Float> beforeBatchEnd) {
        this.beforeBatchEnd = beforeBatchEnd;
    }

    public void setSceneEntityRenderHook(@Nullable ISceneEntityRenderHook sceneEntityRenderHook) {
        this.sceneEntityRenderHook = sceneEntityRenderHook;
    }

    public Vector3f getLastHit() {
        return this.lastHit;
    }

    public BlockHitResult getLastTraceResult() {
        return this.lastTraceResult;
    }

    public float getFov() {
        return this.fov;
    }

    static enum CacheState {
        UNUSED,
        NEED,
        COMPILING,
        COMPILED;

    }

    public static class VertexConsumerWrapper
    implements VertexConsumer {
        final VertexConsumer builder;
        double offsetX;
        double offsetY;
        double offsetZ;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;

        public VertexConsumerWrapper(VertexConsumer builder) {
            this.builder = builder;
        }

        public void addOffset(double offsetX, double offsetY, double offsetZ) {
            this.offsetX += offsetX;
            this.offsetY += offsetY;
            this.offsetZ += offsetZ;
        }

        public void setColor(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public void clerOffset() {
            this.offsetX = 0.0;
            this.offsetY = 0.0;
            this.offsetZ = 0.0;
        }

        public void clearColor() {
            this.r = 1.0f;
            this.g = 1.0f;
            this.b = 1.0f;
            this.a = 1.0f;
        }

        public VertexConsumer vertex(double x, double y, double z) {
            return this.builder.vertex(x + this.offsetX, y + this.offsetY, z + this.offsetZ);
        }

        public VertexConsumer color(int red, int green, int blue, int alpha) {
            return this.builder.color((int)((float)red * this.r), (int)((float)green * this.g), (int)((float)blue * this.b), (int)((float)alpha * this.a));
        }

        public VertexConsumer uv(float u, float v) {
            return this.builder.uv(u, v);
        }

        public VertexConsumer overlayCoords(int u, int v) {
            return this.builder.overlayCoords(u, v);
        }

        public VertexConsumer uv2(int u, int v) {
            return this.builder.uv2(u, v);
        }

        public VertexConsumer normal(float x, float y, float z) {
            return this.builder.normal(x, y, z);
        }

        public void endVertex() {
            this.builder.endVertex();
        }

        public void defaultColor(int defaultR, int defaultG, int defaultB, int defaultA) {
            this.builder.defaultColor(defaultR, defaultG, defaultB, defaultA);
        }

        public void unsetDefaultColor() {
            this.builder.unsetDefaultColor();
        }

        public void setOffsetX(double offsetX) {
            this.offsetX = offsetX;
        }

        public void setOffsetY(double offsetY) {
            this.offsetY = offsetY;
        }

        public void setOffsetZ(double offsetZ) {
            this.offsetZ = offsetZ;
        }
    }
}

