/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.shader.management;

import com.google.common.base.Charsets;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderProgram;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL43;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class Shader {
    public final ShaderType shaderType;
    public final String source;
    private int shaderId;
    private boolean isCompiled;

    public Shader(ShaderType type, String source) {
        this.shaderType = type;
        this.source = source;
        this.shaderId = this.shaderType.createShader();
        if (this.shaderId == 0) {
            LDLib.LOGGER.error("GL Shader Allocation Fail!");
            throw new RuntimeException("GL Shader Allocation Fail!");
        }
    }

    public void attachShader(ShaderProgram program) {
        if (!this.isCompiled) {
            this.compileShader();
        }
        GlStateManager.glAttachShader((int)program.programId, (int)this.shaderId);
    }

    public void deleteShader() {
        if (this.shaderId == 0) {
            return;
        }
        GlStateManager.glDeleteShader((int)this.shaderId);
        this.shaderId = 0;
    }

    public Shader compileShader() {
        if (!this.isCompiled && this.shaderId != 0) {
            Shader.setShaderSourceHackForAmd(this.shaderId, this.source);
            GL20.glCompileShader((int)this.shaderId);
            if (GL20.glGetShaderi((int)this.shaderId, (int)35713) == 0) {
                int maxLength = GL20.glGetShaderi((int)this.shaderId, (int)35716);
                String error = String.format("Unable to compile %s shader object:\n%s", this.shaderType.name(), GL20.glGetShaderInfoLog((int)this.shaderId, (int)maxLength));
                LDLib.LOGGER.error(error);
            }
            this.isCompiled = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setShaderSourceHackForAmd(int shaderId, String source) {
        byte[] bs = source.getBytes(Charsets.UTF_8);
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(bs.length + 1));
        byteBuffer.put(bs);
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
            pointerBuffer.put(byteBuffer);
            GL20C.nglShaderSource((int)shaderId, (int)1, (long)pointerBuffer.address0(), (long)0L);
        }
        finally {
            MemoryUtil.memFree((Buffer)byteBuffer);
        }
    }

    public static Shader loadShader(ShaderType type, String rawShader) {
        return new Shader(type, rawShader).compileShader();
    }

    public static Shader loadShader(ShaderType type, ResourceLocation resourceLocation) throws IOException {
        Optional maybeResource = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
        if (maybeResource.isPresent()) {
            String line;
            Resource resource = (Resource)maybeResource.get();
            InputStream stream = resource.open();
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append('\n');
            }
            stream.close();
            IOUtils.closeQuietly((InputStream)stream);
            return Shader.loadShader(type, stringBuilder.toString());
        }
        throw new IOException("found no resource with ID " + String.valueOf(resourceLocation));
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof Shader) {
            Shader shader = (Shader)obj;
            return Objects.equals(shader.source, this.source) && shader.shaderType == this.shaderType;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shaderType, this.source});
    }

    public static enum ShaderType {
        VERTEX("vertex", ".vsh", 35633, GL20::glCreateShader),
        FRAGMENT("fragment", ".fsh", 35632, GL20::glCreateShader),
        COMPUTE("compute", ".comp", 37305, id -> GL43.glCreateShader((int)37305));

        public final String shaderName;
        public final String shaderExtension;
        public final int shaderMode;
        public final Int2IntFunction shaderCreator;

        private ShaderType(String shaderNameIn, String shaderExtensionIn, int shaderModeIn, Int2IntFunction shaderCreatorIn) {
            this.shaderName = shaderNameIn;
            this.shaderExtension = shaderExtensionIn;
            this.shaderMode = shaderModeIn;
            this.shaderCreator = shaderCreatorIn;
        }

        public int createShader() {
            return this.shaderCreator.get(this.shaderMode);
        }
    }
}

