/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.shader.management;

import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.client.shader.management.Shader;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderProgram;
import com.lowdragmc.lowdraglib.client.shader.uniform.IUniformCallback;
import com.lowdragmc.lowdraglib.utils.PositionedRect;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShaderManager {
    private static final ShaderManager INSTANCE = new ShaderManager();
    private final Reference2ReferenceMap<Shader, ShaderProgram> programs = new Reference2ReferenceOpenHashMap();
    private static TextureTarget TEMP_TARGET;
    private PositionedRect viewPort;

    public static ShaderManager getInstance() {
        return INSTANCE;
    }

    public static boolean allowedShader() {
        return true;
    }

    private ShaderManager() {
    }

    public static TextureTarget getTempTarget() {
        if (TEMP_TARGET == null) {
            TEMP_TARGET = new TextureTarget(1024, 1024, false, Minecraft.ON_OSX);
            TEMP_TARGET.setFilterMode(9729);
            TEMP_TARGET.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return TEMP_TARGET;
    }

    public void reload() {
        this.programs.forEach((shader, shaderProgram) -> {
            shader.deleteShader();
            shaderProgram.delete();
        });
        this.programs.clear();
    }

    public void setViewPort(PositionedRect viewPort) {
        this.viewPort = viewPort;
    }

    public boolean hasViewPort() {
        return this.viewPort != null;
    }

    public void clearViewPort() {
        this.viewPort = null;
    }

    public RenderTarget renderFullImageInFramebuffer(RenderTarget fbo, Shader frag, IUniformCallback consumeCache, Consumer<ShaderProgram> programCreated) {
        if (fbo == null || frag == null || !ShaderManager.allowedShader() || frag.shaderType != Shader.ShaderType.FRAGMENT) {
            return fbo;
        }
        fbo.bindWrite(true);
        ShaderProgram program = (ShaderProgram)this.programs.get((Object)frag);
        if (program == null) {
            program = new ShaderProgram();
            this.programs.put((Object)frag, (Object)program);
            program.attach(Shaders.IMAGE_V).attach(frag);
            if (programCreated != null) {
                programCreated.accept(program);
            }
        }
        program.use(cache -> {
            Minecraft mc = Minecraft.getInstance();
            float time = mc.player != null ? ((float)mc.player.tickCount + mc.getFrameTime()) / 20.0f : (float)System.currentTimeMillis() / 1000.0f;
            cache.glUniform1F("iTime", time);
            cache.glUniform2F("iResolution", fbo.width, fbo.height);
            if (consumeCache != null) {
                consumeCache.apply(cache);
            }
        });
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        buffer.vertex(-1.0, 1.0, 0.0).endVertex();
        buffer.vertex(-1.0, -1.0, 0.0).endVertex();
        buffer.vertex(1.0, -1.0, 0.0).endVertex();
        buffer.vertex(1.0, 1.0, 0.0).endVertex();
        BufferUploader.draw((BufferBuilder.RenderedBuffer)buffer.end());
        program.release();
        if (this.viewPort != null) {
            RenderSystem.viewport((int)this.viewPort.position.x, (int)this.viewPort.position.y, (int)this.viewPort.size.width, (int)this.viewPort.size.height);
        }
        return fbo;
    }
}

