/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class RenderBufferUtils {
    public static void drawLine(Matrix4f pose, VertexConsumer buffer, Vector3f from, Vector3f to, float sr, float sg, float sb, float sa, float er, float eg, float eb, float ea) {
        Vector3f normalDir = new Vector3f(to.x - from.x, to.y - from.y, to.z - from.z).normalize();
        normalDir = pose.transformDirection(normalDir);
        buffer.vertex(pose, from.x, from.y, from.z).color(sr, sg, sb, sa).normal(normalDir.x, normalDir.y, normalDir.z).endVertex();
        buffer.vertex(pose, to.x, to.y, to.z).color(er, eg, eb, ea).normal(normalDir.x, normalDir.y, normalDir.z).endVertex();
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)buffer;
            source.endLastBatch();
        }
    }

    public static void drawLines(PoseStack poseStack, VertexConsumer buffer, List<Vector3f> points, int colorStart, int colorEnd) {
        if (points.size() < 2) {
            return;
        }
        Vector3f lastPoint = points.get(0);
        int sa = colorStart >> 24 & 0xFF;
        int sr = colorStart >> 16 & 0xFF;
        int sg = colorStart >> 8 & 0xFF;
        int sb = colorStart & 0xFF;
        int ea = colorEnd >> 24 & 0xFF;
        int er = colorEnd >> 16 & 0xFF;
        int eg = colorEnd >> 8 & 0xFF;
        int eb = colorEnd & 0xFF;
        ea -= sa;
        er -= sr;
        eg -= sg;
        eb -= sb;
        for (int i = 1; i < points.size(); ++i) {
            float s = ((float)i - 1.0f) / (float)points.size();
            float e = (float)i * 1.0f / (float)points.size();
            Vector3f point = points.get(i);
            RenderBufferUtils.drawLine(poseStack.last().pose(), buffer, lastPoint, point, ((float)sr + (float)er * s) / 255.0f, ((float)sg + (float)eg * s) / 255.0f, ((float)sb + (float)eb * s) / 255.0f, ((float)sa + (float)ea * s) / 255.0f, ((float)sr + (float)er * e) / 255.0f, ((float)sg + (float)eg * e) / 255.0f, ((float)sb + (float)eb * e) / 255.0f, ((float)sa + (float)ea * e) / 255.0f);
        }
    }

    public static void drawCubeFrame(PoseStack poseStack, VertexConsumer buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float r, float g, float b, float a) {
        Matrix4f mat = poseStack.last().pose();
        buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, minY, minZ).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, maxY, minZ).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).endVertex();
        buffer.vertex(mat, minX, minY, maxZ).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).endVertex();
        buffer.vertex(mat, minX, maxY, maxZ).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, minY, maxZ).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, minZ).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).endVertex();
        buffer.vertex(mat, minX, maxY, minZ).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).endVertex();
        buffer.vertex(mat, minX, maxY, maxZ).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).endVertex();
        buffer.vertex(mat, minX, maxY, minZ).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, minZ).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, minY, minZ).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).endVertex();
        buffer.vertex(mat, maxX, minY, maxZ).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).endVertex();
        buffer.vertex(mat, maxX, minY, minZ).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, minZ).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, minY, maxZ).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, minY, maxZ).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, minY, maxZ).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, maxY, maxZ).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).endVertex();
    }

    public static void drawCubeFace(PoseStack poseStack, VertexConsumer buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float red, float green, float blue, float a, boolean shade) {
        Matrix4f mat = poseStack.last().pose();
        float r = red;
        float g = green;
        float b = blue;
        if (minZ != maxZ && minY != maxY) {
            if (shade) {
                r = (float)((double)r * 0.6);
                g = (float)((double)g * 0.6);
                b = (float)((double)b * 0.6);
            }
            buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, minY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, maxY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, maxY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, maxY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, minY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, maxY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, minY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, minY, minZ).color(r, g, b, a).endVertex();
        }
        if (minX != maxX && minZ != maxZ) {
            if (shade) {
                r = red * 0.5f;
                g = green * 0.5f;
                b = blue * 0.5f;
            }
            buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, minY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, minY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, minY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, minY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).endVertex();
            if (shade) {
                r = red;
                g = green;
                b = blue;
            }
            buffer.vertex(mat, minX, maxY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, maxY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, maxY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, maxY, minZ).color(r, g, b, a).endVertex();
        }
        if (minX != maxX && minY != maxY) {
            if (shade) {
                r = red * 0.8f;
                g = green * 0.8f;
                b = blue * 0.8f;
            }
            buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, maxY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, maxY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, maxY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, minY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, minY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, minY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, maxY, maxZ).color(r, g, b, a).endVertex();
            buffer.vertex(mat, minX, minY, maxZ).color(r, g, b, a).endVertex();
        }
    }

    public static void renderCubeFace(PoseStack poseStack, VertexConsumer buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float red, float green, float blue, float a, boolean shade) {
        Matrix4f mat = poseStack.last().pose();
        float r = red;
        float g = green;
        float b = blue;
        if (shade) {
            r = (float)((double)r * 0.6);
            g = (float)((double)g * 0.6);
            b = (float)((double)b * 0.6);
        }
        buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, minX, minY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, minX, maxY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, minX, maxY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, minY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, maxY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, minY, maxZ).color(r, g, b, a).endVertex();
        if (shade) {
            r = red * 0.5f;
            g = green * 0.5f;
            b = blue * 0.5f;
        }
        buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, minY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, minY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, minX, minY, maxZ).color(r, g, b, a).endVertex();
        if (shade) {
            r = red;
            g = green;
            b = blue;
        }
        buffer.vertex(mat, minX, maxY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, minX, maxY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, maxY, minZ).color(r, g, b, a).endVertex();
        if (shade) {
            r = red * 0.8f;
            g = green * 0.8f;
            b = blue * 0.8f;
        }
        buffer.vertex(mat, minX, minY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, minX, maxY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, maxY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, minY, minZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, minX, minY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, minY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, maxX, maxY, maxZ).color(r, g, b, a).endVertex();
        buffer.vertex(mat, minX, maxY, maxZ).color(r, g, b, a).endVertex();
    }

    public static void renderCubeFace(PoseStack poseStack, VertexConsumer buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int color, int combinedLight, TextureAtlasSprite textureSprite) {
        Matrix4f mat = poseStack.last().pose();
        Matrix3f normal = poseStack.last().normal();
        float uMin = textureSprite.getU0();
        float uMax = textureSprite.getU1();
        float vMin = textureSprite.getV0();
        float vMax = textureSprite.getV1();
        buffer.vertex(mat, minX, minY, minZ).color(color).uv(uMin, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, -1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, minY, maxZ).color(color).uv(uMax, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, -1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, maxY, maxZ).color(color).uv(uMax, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, -1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, maxY, minZ).color(color).uv(uMin, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, -1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, minY, minZ).color(color).uv(uMin, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, minZ).color(color).uv(uMax, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, maxZ).color(color).uv(uMax, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, minY, maxZ).color(color).uv(uMin, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, minY, minZ).color(color).uv(uMin, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, -1.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, minY, minZ).color(color).uv(uMax, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, -1.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, minY, maxZ).color(color).uv(uMax, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, -1.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, minY, maxZ).color(color).uv(uMin, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, -1.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, maxY, minZ).color(color).uv(uMin, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 1.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, maxY, maxZ).color(color).uv(uMax, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 1.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, maxZ).color(color).uv(uMax, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 1.0f, 0.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, minZ).color(color).uv(uMin, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 1.0f, 0.0f).endVertex();
        buffer.vertex(mat, minX, minY, minZ).color(color).uv(uMin, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 0.0f, -1.0f).endVertex();
        buffer.vertex(mat, minX, maxY, minZ).color(color).uv(uMax, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 0.0f, -1.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, minZ).color(color).uv(uMax, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 0.0f, -1.0f).endVertex();
        buffer.vertex(mat, maxX, minY, minZ).color(color).uv(uMin, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 0.0f, -1.0f).endVertex();
        buffer.vertex(mat, minX, minY, maxZ).color(color).uv(uMin, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 0.0f, 1.0f).endVertex();
        buffer.vertex(mat, maxX, minY, maxZ).color(color).uv(uMax, vMax).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 0.0f, 1.0f).endVertex();
        buffer.vertex(mat, maxX, maxY, maxZ).color(color).uv(uMax, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 0.0f, 1.0f).endVertex();
        buffer.vertex(mat, minX, maxY, maxZ).color(color).uv(uMin, vMin).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(combinedLight).normal(normal, 0.0f, 0.0f, 1.0f).endVertex();
    }

    public static void drawColorLines(@Nonnull PoseStack poseStack, VertexConsumer builder, List<Vec2> points, int colorStart, int colorEnd, float width) {
        if (points.size() < 2) {
            return;
        }
        Matrix4f mat = poseStack.last().pose();
        Vec2 lastPoint = points.get(0);
        Vec2 point = points.get(1);
        Vector3f vec = null;
        int sa = colorStart >> 24 & 0xFF;
        int sr = colorStart >> 16 & 0xFF;
        int sg = colorStart >> 8 & 0xFF;
        int sb = colorStart & 0xFF;
        int ea = colorEnd >> 24 & 0xFF;
        int er = colorEnd >> 16 & 0xFF;
        int eg = colorEnd >> 8 & 0xFF;
        int eb = colorEnd & 0xFF;
        ea -= sa;
        er -= sr;
        eg -= sg;
        eb -= sb;
        for (int i = 1; i < points.size(); ++i) {
            float s = ((float)i - 1.0f) / (float)points.size();
            float e = (float)i * 1.0f / (float)points.size();
            point = points.get(i);
            vec = new Vector3f(point.x - lastPoint.x, point.y - lastPoint.y, 0.0f).rotateZ(1.5707964f).normalize().mul(-width);
            builder.vertex(mat, lastPoint.x + vec.x, lastPoint.y + vec.y, 0.0f).color(((float)sr + (float)er * s) / 255.0f, ((float)sg + (float)eg * s) / 255.0f, ((float)sb + (float)eb * s) / 255.0f, ((float)sa + (float)ea * s) / 255.0f).endVertex();
            vec.mul(-1.0f);
            builder.vertex(mat, lastPoint.x + vec.x, lastPoint.y + vec.y, 0.0f).color(((float)sr + (float)er * e) / 255.0f, ((float)sg + (float)eg * e) / 255.0f, ((float)sb + (float)eb * e) / 255.0f, ((float)sa + (float)ea * e) / 255.0f).endVertex();
            lastPoint = point;
        }
        vec.mul(-1.0f);
        builder.vertex(mat, point.x + vec.x, point.y + vec.y, 0.0f).color(sr + er, sg + eg, sb + eb, sa + ea).endVertex();
        vec.mul(-1.0f);
        builder.vertex(mat, point.x + vec.x, point.y + vec.y, 0.0f).color(sr + er, sg + eg, sb + eb, sa + ea).endVertex();
    }

    public static void drawColorTexLines(@Nonnull PoseStack poseStack, VertexConsumer builder, List<Vec2> points, int colorStart, int colorEnd, float width) {
        if (points.size() < 2) {
            return;
        }
        Matrix4f mat = poseStack.last().pose();
        Vec2 lastPoint = points.get(0);
        Vec2 point = points.get(1);
        Vector3f vec = null;
        int sa = colorStart >> 24 & 0xFF;
        int sr = colorStart >> 16 & 0xFF;
        int sg = colorStart >> 8 & 0xFF;
        int sb = colorStart & 0xFF;
        int ea = colorEnd >> 24 & 0xFF;
        int er = colorEnd >> 16 & 0xFF;
        int eg = colorEnd >> 8 & 0xFF;
        int eb = colorEnd & 0xFF;
        ea -= sa;
        er -= sr;
        eg -= sg;
        eb -= sb;
        for (int i = 1; i < points.size(); ++i) {
            float s = ((float)i - 1.0f) / (float)points.size();
            float e = (float)i * 1.0f / (float)points.size();
            point = points.get(i);
            float u = ((float)i - 1.0f) / (float)points.size();
            vec = new Vector3f(point.x - lastPoint.x, point.y - lastPoint.y, 0.0f).rotateZ(1.5707964f).normalize().mul(-width);
            builder.vertex(mat, lastPoint.x + vec.x, lastPoint.y + vec.y, 0.0f).uv(u, 0.0f).color(((float)sr + (float)er * s) / 255.0f, ((float)sg + (float)eg * s) / 255.0f, ((float)sb + (float)eb * s) / 255.0f, ((float)sa + (float)ea * s) / 255.0f).endVertex();
            vec.mul(-1.0f);
            builder.vertex(mat, lastPoint.x + vec.x, lastPoint.y + vec.y, 0.0f).uv(u, 1.0f).color(((float)sr + (float)er * e) / 255.0f, ((float)sg + (float)eg * e) / 255.0f, ((float)sb + (float)eb * e) / 255.0f, ((float)sa + (float)ea * e) / 255.0f).endVertex();
            lastPoint = point;
        }
        vec.mul(-1.0f);
        builder.vertex(mat, point.x + vec.x, point.y + vec.y, 0.0f).uv(1.0f, 0.0f).color(sr + er, sg + eg, sb + eb, sa + ea).endVertex();
        vec.mul(-1.0f);
        builder.vertex(mat, point.x + vec.x, point.y + vec.y, 0.0f).uv(1.0f, 1.0f).color(sr + er, sg + eg, sb + eb, sa + ea).endVertex();
    }

    public static void drawCircleLine(@Nonnull PoseStack poseStack, VertexConsumer buffer, Vector3f position, Vector3f normal, int segments, float radius, float red, float green, float blue, float alpha) {
        Matrix4f pose = poseStack.last().pose();
        if (segments < 3) {
            segments = 3;
        }
        Vector3f u = new Vector3f();
        Vector3f v = new Vector3f();
        if (normal.equals((Object)new Vector3f(0.0f, 0.0f, 1.0f))) {
            u.set(1.0f, 0.0f, 0.0f);
            v.set(0.0f, 1.0f, 0.0f);
        } else {
            if (Math.abs(normal.x) < Math.abs(normal.y) && Math.abs(normal.x) < Math.abs(normal.z)) {
                u.set(0.0f, -normal.z, normal.y).normalize();
            } else if (Math.abs(normal.y) < Math.abs(normal.x) && Math.abs(normal.y) < Math.abs(normal.z)) {
                u.set(-normal.z, 0.0f, normal.x).normalize();
            } else {
                u.set(-normal.y, normal.x, 0.0f).normalize();
            }
            v.set((Vector3fc)normal).cross((Vector3fc)u).normalize();
            u.cross((Vector3fc)normal, v).normalize();
        }
        Vector3f prevPoint = new Vector3f();
        Vector3f firstPoint = new Vector3f();
        for (int i = 0; i <= segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float x = (float)((double)radius * Math.cos(angle));
            float y = (float)((double)radius * Math.sin(angle));
            Vector3f currentPoint = new Vector3f((Vector3fc)position).add(u.x * x + v.x * y, u.y * x + v.y * y, u.z * x + v.z * y);
            if (i > 0) {
                RenderBufferUtils.drawLine(pose, buffer, prevPoint, currentPoint, red, green, blue, alpha, red, green, blue, alpha);
            } else {
                firstPoint.set((Vector3fc)currentPoint);
            }
            prevPoint.set((Vector3fc)currentPoint);
        }
        RenderBufferUtils.drawLine(pose, buffer, prevPoint, firstPoint, red, green, blue, alpha, red, green, blue, alpha);
    }

    public static void shapeCone(PoseStack poseStack, VertexConsumer buffer, float x, float y, float z, float baseRadius, float height, int segments, float red, float green, float blue, float alpha, Direction.Axis axis) {
        Matrix4f mat = poseStack.last().pose();
        float segmentDelta = (float)(Math.PI * 2 / (double)segments);
        float theta = 0.0f;
        float cosTheta = 1.0f;
        float sinTheta = 0.0f;
        for (int i = 0; i < segments; ++i) {
            float theta1 = theta + segmentDelta;
            float nextCosTheta = Mth.cos((float)theta1);
            float nextSinTheta = Mth.sin((float)theta1);
            switch (axis) {
                case Y: {
                    buffer.vertex(mat, x + cosTheta * baseRadius, y, z + sinTheta * baseRadius).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x + nextCosTheta * baseRadius, y, z + nextSinTheta * baseRadius).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x, y + height, z).color(red, green, blue, alpha).endVertex();
                    break;
                }
                case X: {
                    buffer.vertex(mat, x, y + cosTheta * baseRadius, z + sinTheta * baseRadius).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x, y + nextCosTheta * baseRadius, z + nextSinTheta * baseRadius).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x + height, y, z).color(red, green, blue, alpha).endVertex();
                    break;
                }
                case Z: {
                    buffer.vertex(mat, x + cosTheta * baseRadius, y + sinTheta * baseRadius, z).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x + nextCosTheta * baseRadius, y + nextSinTheta * baseRadius, z).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x, y, z + height).color(red, green, blue, alpha).endVertex();
                }
            }
            theta = theta1;
            cosTheta = nextCosTheta;
            sinTheta = nextSinTheta;
        }
    }

    public static void shapeCircle(PoseStack poseStack, VertexConsumer buffer, float x, float y, float z, float baseRadius, int segments, float red, float green, float blue, float alpha, Direction.Axis axis) {
        Matrix4f mat = poseStack.last().pose();
        float segmentDelta = (float)(Math.PI * 2 / (double)segments);
        float theta = 0.0f;
        float cosTheta = 1.0f;
        float sinTheta = 0.0f;
        for (int i = 0; i < segments; ++i) {
            float theta1 = theta + segmentDelta;
            float nextCosTheta = Mth.cos((float)theta1);
            float nextSinTheta = Mth.sin((float)theta1);
            switch (axis) {
                case Y: {
                    buffer.vertex(mat, x, y, z).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x + nextCosTheta * baseRadius, y, z + nextSinTheta * baseRadius).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x + cosTheta * baseRadius, y, z + sinTheta * baseRadius).color(red, green, blue, alpha).endVertex();
                    break;
                }
                case X: {
                    buffer.vertex(mat, x, y, z).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x, y + nextCosTheta * baseRadius, z + nextSinTheta * baseRadius).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x, y + cosTheta * baseRadius, z + sinTheta * baseRadius).color(red, green, blue, alpha).endVertex();
                    break;
                }
                case Z: {
                    buffer.vertex(mat, x, y, z).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x + nextCosTheta * baseRadius, y + nextSinTheta * baseRadius, z).color(red, green, blue, alpha).endVertex();
                    buffer.vertex(mat, x + cosTheta * baseRadius, y + sinTheta * baseRadius, z).color(red, green, blue, alpha).endVertex();
                }
            }
            theta = theta1;
            cosTheta = nextCosTheta;
            sinTheta = nextSinTheta;
        }
    }

    public static void shapeCube(PoseStack poseStack, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha) {
        int[][] faces;
        Matrix4f mat = poseStack.last().pose();
        float minX = Math.min(x1, x2);
        float maxX = Math.max(x1, x2);
        float minY = Math.min(y1, y2);
        float maxY = Math.max(y1, y2);
        float minZ = Math.min(z1, z2);
        float maxZ = Math.max(z1, z2);
        float[][] vertices = new float[][]{{minX, minY, minZ}, {maxX, minY, minZ}, {maxX, maxY, minZ}, {minX, maxY, minZ}, {minX, minY, maxZ}, {maxX, minY, maxZ}, {maxX, maxY, maxZ}, {minX, maxY, maxZ}};
        int[][] nArrayArray = faces = new int[][]{{0, 1, 2, 2, 3, 0}, {1, 5, 6, 6, 2, 1}, {5, 4, 7, 7, 6, 5}, {4, 0, 3, 3, 7, 4}, {3, 2, 6, 6, 7, 3}, {4, 5, 1, 1, 0, 4}};
        int n = nArrayArray.length;
        for (int i = 0; i < n; ++i) {
            int[] face;
            for (int index : face = nArrayArray[i]) {
                float[] vertex = vertices[index];
                buffer.vertex(mat, vertex[0], vertex[1], vertex[2]).color(red, green, blue, alpha).endVertex();
            }
        }
    }

    public static void shapeSphere(PoseStack poseStack, VertexConsumer buffer, float x, float y, float z, float radius, int stacks, int slices, float red, float green, float blue, float alpha) {
        Matrix4f mat = poseStack.last().pose();
        float stackStep = (float)Math.PI / (float)stacks;
        float sliceStep = (float)(Math.PI * 2 / (double)slices);
        for (int i = 0; i < stacks; ++i) {
            float stackAngle1 = (float)i * stackStep;
            float stackAngle2 = (float)(i + 1) * stackStep;
            float sinStack1 = (float)Math.sin(stackAngle1);
            float cosStack1 = (float)Math.cos(stackAngle1);
            float sinStack2 = (float)Math.sin(stackAngle2);
            float cosStack2 = (float)Math.cos(stackAngle2);
            for (int j = 0; j < slices; ++j) {
                float sliceAngle1 = (float)j * sliceStep;
                float sliceAngle2 = (float)(j + 1) * sliceStep;
                float sinSlice1 = (float)Math.sin(sliceAngle1);
                float cosSlice1 = (float)Math.cos(sliceAngle1);
                float sinSlice2 = (float)Math.sin(sliceAngle2);
                float cosSlice2 = (float)Math.cos(sliceAngle2);
                float[] v1 = new float[]{x + radius * sinStack1 * cosSlice1, y + radius * cosStack1, z + radius * sinStack1 * sinSlice1};
                float[] v2 = new float[]{x + radius * sinStack2 * cosSlice1, y + radius * cosStack2, z + radius * sinStack2 * sinSlice1};
                float[] v3 = new float[]{x + radius * sinStack2 * cosSlice2, y + radius * cosStack2, z + radius * sinStack2 * sinSlice2};
                float[] v4 = new float[]{x + radius * sinStack1 * cosSlice2, y + radius * cosStack1, z + radius * sinStack1 * sinSlice2};
                buffer.vertex(mat, v1[0], v1[1], v1[2]).color(red, green, blue, alpha).endVertex();
                buffer.vertex(mat, v2[0], v2[1], v2[2]).color(red, green, blue, alpha).endVertex();
                buffer.vertex(mat, v3[0], v3[1], v3[2]).color(red, green, blue, alpha).endVertex();
                buffer.vertex(mat, v3[0], v3[1], v3[2]).color(red, green, blue, alpha).endVertex();
                buffer.vertex(mat, v4[0], v4[1], v4[2]).color(red, green, blue, alpha).endVertex();
                buffer.vertex(mat, v1[0], v1[1], v1[2]).color(red, green, blue, alpha).endVertex();
            }
        }
    }
}

