/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.utils;

import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43;

@OnlyIn(value=Dist.CLIENT)
public class ShaderUtils {
    private static final boolean DEBUG_LABEL_AVAILABLE = GL.getCapabilities().GL_KHR_debug;

    public static void fastBlit(RenderTarget from, RenderTarget to) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask((boolean)false);
        to.bindWrite(true);
        Shaders.getBlitShader().setSampler("DiffuseSampler", (Object)from.getColorTextureId());
        Shaders.getBlitShader().apply();
        GlStateManager._enableBlend();
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        bufferbuilder.vertex(-1.0, 1.0, 0.0).endVertex();
        bufferbuilder.vertex(-1.0, -1.0, 0.0).endVertex();
        bufferbuilder.vertex(1.0, -1.0, 0.0).endVertex();
        bufferbuilder.vertex(1.0, 1.0, 0.0).endVertex();
        BufferUploader.draw((BufferBuilder.RenderedBuffer)bufferbuilder.end());
        Shaders.getBlitShader().clear();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._enableDepthTest();
    }

    public static void warpGLDebugLabel(String message, Runnable block) {
        if (DEBUG_LABEL_AVAILABLE && Platform.isDevEnv()) {
            GL43.glPushDebugGroup((int)33354, (int)0, (CharSequence)message);
            block.run();
            GL43.glPopDebugGroup();
        } else {
            block.run();
        }
    }
}

