/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.core.mixins;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBakery.class})
public abstract class ModelBakeryMixin {
    @Shadow
    @Final
    private Map<ResourceLocation, UnbakedModel> f_119212_;

    @Shadow
    protected abstract void m_119352_(ResourceLocation var1, UnbakedModel var2);

    @Shadow
    protected abstract BlockModel m_119364_(ResourceLocation var1) throws IOException;

    @Redirect(method={"getModel"}, at=@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;[Ljava/lang/Object;)V"))
    protected void injectStateToModelLocation(Logger logger, String string, Object[] objects) {
        String location = objects[0].toString();
        if (location.endsWith("#inventory") && BuiltInRegistries.ITEM.get(new ResourceLocation(location.substring(0, location.length() - "#inventory".length()))) instanceof IItemRendererProvider) {
            return;
        }
        logger.warn(location, objects);
    }

    @Inject(method={"loadModel"}, at={@At(value="HEAD")}, cancellable=true)
    protected void injectLoadModel(ResourceLocation blockstateLocation, CallbackInfo ci) {
        ResourceLocation resourceLocation;
        Block block;
        ModelResourceLocation modelResourceLocation;
        if (blockstateLocation instanceof ModelResourceLocation && !Objects.equals((modelResourceLocation = (ModelResourceLocation)blockstateLocation).getVariant(), "inventory") && (block = (Block)BuiltInRegistries.BLOCK.get(resourceLocation = new ResourceLocation(blockstateLocation.getNamespace(), blockstateLocation.getPath()))) instanceof IBlockRendererProvider) {
            UnbakedModel model = this.f_119212_.computeIfAbsent(LDLib.location("block/renderer_model"), modelLocation -> {
                try {
                    return ModelFactory.getLDLibModel((UnbakedModel)this.m_119364_((ResourceLocation)modelLocation));
                }
                catch (IOException e) {
                    LDLib.LOGGER.error("Couldn't load ldlib:renderer_model", (Throwable)e);
                    return this.f_119212_.get(ModelBakery.MISSING_MODEL_LOCATION);
                }
            });
            this.m_119352_((ResourceLocation)modelResourceLocation, model);
            ci.cancel();
        }
    }
}

