/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.screen.tooltip.IngredientTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class ListEmiIngredient
implements EmiIngredient {
    private final List<? extends EmiIngredient> ingredients;
    private final Supplier<EmiIngredient> currentSupplier;
    private final List<EmiStack> fullList;
    private long amount;
    private float chance = 1.0f;

    public ListEmiIngredient(List<? extends EmiIngredient> ingredients, Supplier<EmiIngredient> currentSupplier, long amount) {
        this.ingredients = ingredients;
        this.fullList = ingredients.stream().flatMap(i -> i.getEmiStacks().stream()).toList();
        this.currentSupplier = currentSupplier;
        if (this.fullList.isEmpty()) {
            throw new IllegalArgumentException("ListEmiIngredient cannot be empty");
        }
        this.amount = amount;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ListEmiIngredient) {
            ListEmiIngredient other = (ListEmiIngredient)obj;
            return other.getEmiStacks().equals(this.getEmiStacks());
        }
        return false;
    }

    public int hashCode() {
        return this.fullList.hashCode();
    }

    public EmiIngredient copy() {
        dev.emi.emi.api.stack.ListEmiIngredient stack = new dev.emi.emi.api.stack.ListEmiIngredient(this.ingredients, this.amount);
        stack.setChance(this.chance);
        return stack;
    }

    public String toString() {
        return "Ingredient" + String.valueOf(this.getEmiStacks());
    }

    public List<EmiStack> getEmiStacks() {
        return this.fullList;
    }

    public long getAmount() {
        return this.amount;
    }

    public EmiIngredient setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    public float getChance() {
        return this.chance;
    }

    public EmiIngredient setChance(float chance) {
        this.chance = chance;
        return this;
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        EmiIngredient current = this.currentSupplier.get();
        if ((flags & 1) != 0) {
            current.render(draw, x, y, delta, -3);
        }
        if ((flags & 2) != 0) {
            current.copy().setAmount(this.amount).render(draw, x, y, delta, 2);
        }
        if ((flags & 4) != 0) {
            EmiRender.renderIngredientIcon((EmiIngredient)this, (GuiGraphics)draw, (int)x, (int)y);
        }
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"tooltip.emi.accepts"))));
        tooltip.add(new IngredientTooltipComponent(this.ingredients));
        tooltip.addAll(this.currentSupplier.get().getTooltip());
        return tooltip;
    }
}

