/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.emi;

import com.lowdragmc.lowdraglib.emi.ModularForegroundRenderWidget;
import com.lowdragmc.lowdraglib.emi.ModularWrapperWidget;
import com.lowdragmc.lowdraglib.emi.RecipeIngredientSlotWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TankWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;

public abstract class ModularEmiRecipe<T extends Widget>
implements EmiRecipe {
    public static final List<ModularWrapper<?>> CACHE_OPENED = new ArrayList();
    protected Supplier<T> widget;
    protected List<EmiIngredient> inputs;
    protected List<EmiStack> outputs;
    protected List<EmiIngredient> catalysts;
    protected int width;
    protected int height;
    public static ModularWrapper<?> TEMP_CACHE = null;

    public ModularEmiRecipe(Supplier<T> widgetSupplier) {
        this.widget = widgetSupplier;
        this.inputs = new ArrayList<EmiIngredient>();
        this.outputs = new ArrayList<EmiStack>();
        this.catalysts = new ArrayList<EmiIngredient>();
        Widget widget = (Widget)widgetSupplier.get();
        this.width = widget.getSize().width;
        this.height = widget.getSize().height;
        for (Widget w : this.getFlatWidgetCollection(widget)) {
            if (!(w instanceof IRecipeIngredientSlot)) continue;
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)((Object)w);
            IngredientIO io = slot.getIngredientIO();
            for (Object ingredient : slot.getXEIIngredients()) {
                if (!(ingredient instanceof EmiIngredient)) continue;
                EmiIngredient emiIngredient = (EmiIngredient)ingredient;
                if (io == IngredientIO.INPUT || io == IngredientIO.BOTH) {
                    this.inputs.add(emiIngredient);
                }
                if (io == IngredientIO.OUTPUT || io == IngredientIO.BOTH) {
                    this.outputs.add((EmiStack)emiIngredient.getEmiStacks().get(0));
                }
                if (io != IngredientIO.CATALYST) continue;
                this.catalysts.add(emiIngredient);
            }
        }
    }

    public List<Widget> getFlatWidgetCollection(T widgetIn) {
        ArrayList<Widget> widgetList = new ArrayList<Widget>();
        if (widgetIn instanceof WidgetGroup) {
            WidgetGroup group = (WidgetGroup)widgetIn;
            for (Widget widget : group.widgets) {
                widgetList.add(widget);
                if (!(widget instanceof WidgetGroup)) continue;
                WidgetGroup group1 = (WidgetGroup)widget;
                widgetList.addAll(group1.getContainedWidgets(true));
            }
        } else {
            widgetList.add((Widget)widgetIn);
        }
        return widgetList;
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWidgets(WidgetHolder widgets) {
        Widget widget = (Widget)this.widget.get();
        ModularWrapper<Widget> modular = new ModularWrapper<Widget>(widget);
        modular.setRecipeWidget(0, 0);
        List<ModularWrapper<?>> list = CACHE_OPENED;
        synchronized (list) {
            CACHE_OPENED.add(modular);
        }
        ArrayList<dev.emi.emi.api.widget.Widget> slots = new ArrayList<dev.emi.emi.api.widget.Widget>();
        for (Widget w : this.getFlatWidgetCollection(widget)) {
            IngredientIO io;
            DraggableScrollableWidgetGroup draggable;
            if (!(w instanceof IRecipeIngredientSlot)) continue;
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)((Object)w);
            WidgetGroup widgetGroup = w.getParent();
            if (widgetGroup instanceof DraggableScrollableWidgetGroup && (draggable = (DraggableScrollableWidgetGroup)widgetGroup).isUseScissor() || (io = slot.getIngredientIO()) == null || io == IngredientIO.RENDER_ONLY) continue;
            EmiIngredient ingredients = EmiIngredient.of(slot.getXEIIngredients());
            RecipeIngredientSlotWidget slotWidget = null;
            if (slot instanceof SlotWidget) {
                SlotWidget slotW = (SlotWidget)slot;
                this.clearSlotWidgetHandler(slotW, 0);
                slotWidget = new dev.emi.emi.api.widget.SlotWidget(ingredients, w.getPosition().x, w.getPosition().y);
            } else if (slot instanceof com.lowdragmc.lowdraglib.gui.widget.TankWidget) {
                com.lowdragmc.lowdraglib.gui.widget.TankWidget tankW = (com.lowdragmc.lowdraglib.gui.widget.TankWidget)slot;
                this.clearTankWidgetHandler(tankW);
                long capacity = Math.max(1L, ingredients.getAmount());
                slotWidget = new TankWidget(ingredients, w.getPosition().x, w.getPosition().y, w.getSize().width, w.getSize().height, capacity);
            }
            if (slotWidget == null) {
                slotWidget = new RecipeIngredientSlotWidget(slot);
            }
            slotWidget.customBackground(null, w.getPosition().x, w.getPosition().y, w.getSize().width, w.getSize().height).drawBack(false);
            if (io == IngredientIO.CATALYST) {
                slotWidget.catalyst(true);
            } else if (io == IngredientIO.OUTPUT) {
                slotWidget.recipeContext(this);
            }
            for (Component component : w.getTooltipTexts()) {
                slotWidget.appendTooltip(component);
            }
            slots.add((dev.emi.emi.api.widget.Widget)slotWidget);
        }
        widgets.add((dev.emi.emi.api.widget.Widget)new ModularWrapperWidget(modular, slots));
        slots.forEach(arg_0 -> ((WidgetHolder)widgets).add(arg_0));
        widgets.add((dev.emi.emi.api.widget.Widget)new ModularForegroundRenderWidget(modular));
    }

    public void clearSlotWidgetHandler(SlotWidget slotW, int slotIndex) {
        slotW.setHandlerSlot(IItemTransfer.EMPTY, slotIndex);
        slotW.setDrawHoverOverlay(false).setDrawHoverTips(false);
    }

    public void clearTankWidgetHandler(com.lowdragmc.lowdraglib.gui.widget.TankWidget tankW) {
        tankW.setFluidTank(IFluidStorage.EMPTY);
        tankW.setDrawHoverOverlay(false).setDrawHoverTips(false);
    }

    public void addTempWidgets(WidgetHolder widgets) {
        if (TEMP_CACHE != null) {
            ModularEmiRecipe.TEMP_CACHE.modularUI.triggerCloseListeners();
            TEMP_CACHE = null;
        }
        Widget widget = (Widget)this.widget.get();
        ModularWrapper<Widget> modular = new ModularWrapper<Widget>(widget);
        modular.setRecipeWidget(0, 0);
        widgets.add((dev.emi.emi.api.widget.Widget)new ModularWrapperWidget(modular, new ArrayList<dev.emi.emi.api.widget.Widget>()));
        TEMP_CACHE = modular;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }
}

