/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.emi;

import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import dev.emi.emi.api.widget.Bounds;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ModularWrapperWidget
extends dev.emi.emi.api.widget.Widget
implements ContainerEventHandler {
    @Nullable
    private GuiEventListener focused;
    private boolean isDragging;
    public final ModularWrapper<?> modular;
    public final List<dev.emi.emi.api.widget.Widget> slots;

    public ModularWrapperWidget(ModularWrapper<?> modular, List<dev.emi.emi.api.widget.Widget> slots) {
        this.modular = modular;
        this.slots = slots;
    }

    public Bounds getBounds() {
        return new Bounds(0, 0, ((Widget)this.modular.getWidget()).getSize().width, ((Widget)this.modular.getWidget()).getSize().height);
    }

    public void render(@Nonnull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.modular.draw(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        if (this.modular.tooltipTexts != null && !this.modular.tooltipTexts.isEmpty() && !(this.modular.modularUI.mainGroup.getHoverElement(mouseX + this.modular.getLeft(), mouseY + this.modular.getTop()) instanceof IRecipeIngredientSlot)) {
            List<ClientTooltipComponent> tooltips = this.modular.tooltipTexts.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).collect(Collectors.toList());
            if (this.modular.tooltipComponent != null) {
                tooltips.add(DrawerHelper.getClientTooltipComponent(this.modular.tooltipComponent));
            }
            return tooltips;
        }
        return super.getTooltip(mouseX, mouseY);
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return this.modular.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.modular.mouseClicked(mouseX + this.modular.getLeft(), mouseY + this.modular.getTop(), button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        return this.modular.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public void mouseMoved(double pMouseX, double pMouseY) {
        this.modular.mouseMoved(pMouseX, pMouseY);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.modular.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta) {
        return this.modular.mouseScrolled(pMouseX, pMouseY, pDelta);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        return this.modular.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        return this.modular.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        return this.modular.charTyped(pCodePoint, pModifiers);
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        this.focused = focused;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }
}

