/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.forge;

import com.lowdragmc.lowdraglib.async.AsyncThreadData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ldlib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonListeners {
    @SubscribeEvent
    public static void onWorldUnLoad(LevelEvent.Unload event) {
        LevelAccessor world = event.getLevel();
        if (!world.isClientSide() && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            AsyncThreadData.getOrCreate(serverLevel).releaseExecutorService();
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        Iterable levels = event.getServer().getAllLevels();
        for (ServerLevel level : levels) {
            if (level.isClientSide()) continue;
            AsyncThreadData.getOrCreate(level).releaseExecutorService();
        }
    }
}

