/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.animation;

import com.lowdragmc.lowdraglib.gui.animation.Animation;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.interpolate.IEase;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Transform
extends Animation {
    protected int xOffset;
    protected int yOffset;
    protected float scale = 1.0f;
    protected boolean in;

    public Transform offset(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        return this;
    }

    public Transform setScale(float scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public Transform duration(long duration) {
        return (Transform)super.duration(duration);
    }

    @Override
    public Transform delay(long delay) {
        return (Transform)super.delay(delay);
    }

    @Override
    public Transform ease(IEase ease) {
        return (Transform)super.ease(ease);
    }

    @Override
    public Transform onUpdate(FloatConsumer onUpdate) {
        return (Transform)super.onUpdate(onUpdate);
    }

    @Override
    public Animation onFinish(Runnable onFinish) {
        return super.onFinish(onFinish);
    }

    @Override
    public Animation size(@Nullable Size size) {
        return super.size(size);
    }

    @Override
    public Animation position(@Nullable Position position) {
        return super.position(position);
    }

    public boolean isIn() {
        return this.in;
    }

    public boolean isOut() {
        return !this.in;
    }

    public Animation setIn() {
        this.in = true;
        return this;
    }

    public Animation setOut() {
        this.in = false;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void pre(@NotNull GuiGraphics graphics) {
        graphics.pose().pushPose();
        Position position = this.widget.getPosition();
        Size size = this.widget.getSize();
        float oX = (float)position.x + (float)size.width / 2.0f;
        float oY = (float)position.y + (float)size.height / 2.0f;
        if (this.isIn()) {
            graphics.pose().translate((float)this.xOffset * (1.0f - this.getTime()), (float)this.yOffset * (1.0f - this.getTime()), 0.0f);
        } else {
            graphics.pose().translate((float)this.xOffset * this.getTime(), (float)this.yOffset * this.getTime(), 0.0f);
        }
        graphics.pose().translate(oX, oY, 0.0f);
        if (this.isIn()) {
            graphics.pose().scale(this.scale + (1.0f - this.scale) * this.getTime(), this.scale + (1.0f - this.scale) * this.getTime(), 1.0f);
        } else {
            graphics.pose().scale(this.scale + (1.0f - this.scale) * (1.0f - this.getTime()), this.scale + (1.0f - this.scale) * (1.0f - this.getTime()), 1.0f);
        }
        graphics.pose().translate(-oX, -oY, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void post(@NotNull GuiGraphics graphics) {
        graphics.pose().popPose();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float tickTime = this.getTick();
        if (tickTime >= (float)this.delay) {
            if (this.interpolator != null) {
                this.interpolator.update(tickTime);
            }
            this.pre(graphics);
            this.widget.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            this.post(graphics);
        } else if (this.isOut()) {
            this.widget.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float tickTime = this.getTick();
        if (tickTime >= (float)this.delay) {
            if (this.interpolator != null) {
                this.interpolator.update(tickTime);
            }
            this.pre(graphics);
            this.widget.drawInForeground(graphics, mouseX, mouseY, partialTicks);
            this.post(graphics);
        } else if (this.isOut()) {
            this.widget.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public Transform scale(float scale) {
        this.scale = scale;
        return this;
    }
}

