/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.compass.CompassNode;
import com.lowdragmc.lowdraglib.gui.compass.CompassSection;
import com.lowdragmc.lowdraglib.gui.compass.CompassSelectorWidget;
import com.lowdragmc.lowdraglib.gui.compass.CompassView;
import com.lowdragmc.lowdraglib.gui.compass.ICompassUIConfig;
import com.lowdragmc.lowdraglib.gui.compass.ILayoutComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.BlankComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.CompassComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.HeaderComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.ImageComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.IngredientComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.RecipeComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.SceneComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.TextBoxComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.Action;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.InformationAction;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.SceneAction;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.mojang.realmsclient.util.JsonUtils;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@OnlyIn(value=Dist.CLIENT)
public final class CompassManager
implements ResourceManagerReloadListener {
    public static final CompassManager INSTANCE = new CompassManager();
    public static final int MAX_HOBER_TICK = 20;
    private int cHoverTick = 0;
    private long startedTick = Long.MAX_VALUE;
    private ItemStack lastStack = ItemStack.EMPTY;
    public boolean devMode = Platform.isDevEnv();
    private final Map<String, Supplier<ILayoutComponent>> COMPONENTS = new HashMap<String, Supplier<ILayoutComponent>>();
    private final Map<String, Function<Element, Action>> ACTION_CREATORS = new HashMap<String, Function<Element, Action>>();
    private final Map<String, ICompassUIConfig> CONFIGS = new HashMap<String, ICompassUIConfig>();
    private final Map<Item, Set<ResourceLocation>> itemLookup = new HashMap<Item, Set<ResourceLocation>>();
    public final Map<String, Map<ResourceLocation, CompassSection>> sections = new HashMap<String, Map<ResourceLocation, CompassSection>>();
    public final Map<String, Map<ResourceLocation, CompassNode>> nodes = new HashMap<String, Map<ResourceLocation, CompassNode>>();
    public final Map<ResourceLocation, Map<String, Document>> nodePages = new HashMap<ResourceLocation, Map<String, Document>>();

    private CompassManager() {
    }

    public void registerAction(String name, Function<Element, Action> creator) {
        this.ACTION_CREATORS.put(name, creator);
    }

    public void registerComponent(String name, Supplier<ILayoutComponent> clazz) {
        this.COMPONENTS.put(name, clazz);
    }

    public void registerUIConfig(String modID, ICompassUIConfig config) {
        this.CONFIGS.put(modID, config);
    }

    public void registerItemLookup(Item item, ResourceLocation nodeName) {
        this.itemLookup.computeIfAbsent(item, k -> new HashSet()).add(nodeName);
    }

    @Nullable
    public ILayoutComponent createComponent(String name, Element element) {
        Supplier<ILayoutComponent> creator = this.COMPONENTS.get(name);
        return creator == null ? null : creator.get().fromXml(element);
    }

    @Nullable
    public Action createAction(Element element) {
        Function<Element, Action> creator = this.ACTION_CREATORS.get(element.getTagName());
        return creator == null ? null : creator.apply(element);
    }

    public ICompassUIConfig getUIConfig(String modID) {
        return this.CONFIGS.getOrDefault(modID, ICompassUIConfig.getDefault());
    }

    public void init() {
        this.registerComponent("text", TextBoxComponent::new);
        this.registerComponent("image", ImageComponent::new);
        for (HeaderComponent.Header header : HeaderComponent.Header.values()) {
            this.registerComponent(header.name(), HeaderComponent::new);
            this.registerComponent(header.name(), HeaderComponent::new);
            this.registerComponent(header.name(), HeaderComponent::new);
        }
        this.registerComponent("br", BlankComponent::new);
        this.registerComponent("recipe", RecipeComponent::new);
        this.registerComponent("scene", SceneComponent::new);
        this.registerComponent("ingredient", IngredientComponent::new);
        this.registerComponent("compass", CompassComponent::new);
        this.registerAction("scene", SceneAction::new);
        this.registerAction("information", InformationAction::new);
    }

    public void onResourceManagerReload(@Nonnull ResourceManager resourceManager) {
        String path;
        InputStreamReader reader;
        Resource resource;
        ResourceLocation key;
        this.sections.clear();
        this.nodes.clear();
        this.nodePages.clear();
        for (Map.Entry entry : resourceManager.listResources("compass/sections", rl -> rl.getPath().endsWith(".json")).entrySet()) {
            key = (ResourceLocation)entry.getKey();
            resource = (Resource)entry.getValue();
            try {
                reader = new InputStreamReader(resource.open(), StandardCharsets.UTF_8);
                try {
                    path = key.getPath().replace("compass/sections/", "");
                    path = path.substring(0, path.length() - 5);
                    CompassSection section = new CompassSection(new ResourceLocation(key.getNamespace(), path), JsonParser.parseReader((Reader)reader).getAsJsonObject());
                    this.sections.computeIfAbsent(key.getNamespace(), k -> new HashMap()).put(section.sectionName, section);
                }
                finally {
                    reader.close();
                }
            }
            catch (Exception e) {
                LDLib.LOGGER.error("loading compass section {} failed", entry.getKey(), (Object)e);
            }
        }
        for (Map.Entry entry : resourceManager.listResources("compass/nodes", rl -> rl.getPath().endsWith(".json")).entrySet()) {
            key = (ResourceLocation)entry.getKey();
            resource = (Resource)entry.getValue();
            try {
                reader = new InputStreamReader(resource.open(), StandardCharsets.UTF_8);
                try {
                    path = key.getPath().replace("compass/nodes/", "");
                    path = path.substring(0, path.length() - 5);
                    CompassNode node = new CompassNode(new ResourceLocation(key.getNamespace(), path), JsonParser.parseReader((Reader)reader).getAsJsonObject());
                    this.nodes.computeIfAbsent(key.getNamespace(), k -> new HashMap()).put(node.nodeName, node);
                }
                finally {
                    reader.close();
                }
            }
            catch (Exception e) {
                LDLib.LOGGER.error("loading compass node {} failed", entry.getKey(), (Object)e);
            }
        }
        for (Map.Entry<Object, Object> entry : this.nodes.entrySet()) {
            Iterator iterator = ((Map)entry.getValue()).entrySet().iterator();
            while (iterator.hasNext()) {
                CompassNode node = (CompassNode)iterator.next().getValue();
                ResourceLocation sectionName = new ResourceLocation(JsonUtils.getStringOr((String)"section", (JsonObject)node.getConfig(), (String)"default"));
                CompassSection section = (CompassSection)this.sections.getOrDefault(entry.getKey(), Collections.emptyMap()).get(sectionName);
                if (section != null) {
                    node.setSection(section);
                    node.getItems().forEach(item -> this.itemLookup.computeIfAbsent((Item)item, k -> new HashSet()).add(node.nodeName));
                    continue;
                }
                LDLib.LOGGER.error("node {}'s section {} not found", (Object)node.getNodeName(), (Object)sectionName);
                iterator.remove();
            }
        }
        for (Map map : this.nodes.values()) {
            map.values().forEach(CompassNode::initRelation);
        }
    }

    public static void onComponentClick(String link, ClickData cd) {
        if (ResourceLocation.isValidResourceLocation((String)link)) {
            INSTANCE.openCompass(new ResourceLocation(link));
        }
    }

    public void onCPressed(ItemStack itemStack) {
        long tick = Minecraft.getInstance().level.getGameTime();
        if (!ItemStack.isSameItemSameTags((ItemStack)this.lastStack, (ItemStack)itemStack)) {
            this.lastStack = itemStack;
            this.cHoverTick = 0;
            this.startedTick = tick;
        } else {
            this.cHoverTick = (int)(tick - this.startedTick);
        }
        if (this.cHoverTick < 0 || this.cHoverTick > 20) {
            this.lastStack = ItemStack.EMPTY;
            this.cHoverTick = 0;
            this.startedTick = tick;
        }
        if (this.cHoverTick == 20) {
            this.openCompass(this.getNodesByItem(itemStack.getItem()).toArray(new CompassNode[0]));
        }
    }

    public float getCHoverProgress() {
        return (float)this.cHoverTick * 1.0f / 20.0f;
    }

    public void clearCPressed() {
        this.cHoverTick = 0;
        this.startedTick = Long.MAX_VALUE;
        this.lastStack = ItemStack.EMPTY;
    }

    public void openCompass(ResourceLocation nodeLocation) {
        CompassNode node = this.nodes.getOrDefault(nodeLocation.getNamespace(), Collections.emptyMap()).getOrDefault(nodeLocation, null);
        if (node != null) {
            this.openCompass(node);
        }
    }

    public void openCompass(CompassNode ... compassNodes) {
        ModularUI uiTemplate;
        IUIHolder holder = new IUIHolder(){

            @Override
            public ModularUI createUI(Player entityPlayer) {
                return null;
            }

            @Override
            public boolean isInvalid() {
                return true;
            }

            @Override
            public boolean isRemote() {
                return true;
            }

            @Override
            public void markAsDirty() {
            }
        };
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer entityPlayer = minecraft.player;
        if (compassNodes.length == 1) {
            uiTemplate = new ModularUI(holder, (Player)entityPlayer).widget(new CompassView(compassNodes[0]));
        } else if (compassNodes.length > 1) {
            uiTemplate = new ModularUI(210, 100, holder, (Player)entityPlayer).widget(new CompassSelectorWidget(Arrays.asList(compassNodes)));
        } else {
            return;
        }
        uiTemplate.initWidgets();
        ModularUIGuiContainer ModularUIGuiContainer2 = new ModularUIGuiContainer(uiTemplate, entityPlayer.containerMenu.containerId);
        minecraft.setScreen((Screen)ModularUIGuiContainer2);
        entityPlayer.containerMenu = ModularUIGuiContainer2.getMenu();
    }

    public boolean hasCompass(Item item) {
        return !this.getNodesByItem(item).isEmpty();
    }

    public List<CompassNode> getNodesByItem(Item item) {
        return this.itemLookup.getOrDefault(item, Collections.emptySet()).stream().map(nodeName -> (CompassNode)this.nodes.getOrDefault(nodeName.getNamespace(), Collections.emptyMap()).get(nodeName)).toList();
    }

    @Nullable
    public CompassNode getNodeByName(ResourceLocation nodeName) {
        return (CompassNode)this.nodes.getOrDefault(nodeName.getNamespace(), Collections.emptyMap()).get(nodeName);
    }

    @Nullable
    public CompassSection getSectionByName(ResourceLocation sectionName) {
        return (CompassSection)this.sections.getOrDefault(sectionName.getNamespace(), Collections.emptyMap()).get(sectionName);
    }
}

