/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass;

import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.compass.CompassNode;
import com.lowdragmc.lowdraglib.gui.compass.ICompassUIConfig;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class CompassSelectorWidget
extends WidgetGroup {
    private final List<CompassNode> nodes;

    public CompassSelectorWidget(List<CompassNode> nodes) {
        super(0, 0, 210, 100);
        this.setClientSideWidget();
        this.nodes = nodes;
    }

    @Override
    public void initWidget() {
        super.initWidget();
        this.setBackground(new GuiTextureGroup(ColorPattern.BLACK.rectTexture(), ColorPattern.T_GRAY.borderTexture(1)));
        DraggableScrollableWidgetGroup listGroup = new DraggableScrollableWidgetGroup(4, 4, 202, 92).setYScrollBarWidth(2).setYBarStyle(null, ColorPattern.T_WHITE.rectTexture().setRadius(1.0f)).setBackground((IGuiTexture)ColorPattern.T_GRAY.rectTexture().setRadius(1.0f));
        this.addWidget(listGroup);
        Map<ResourceLocation, List<CompassNode>> map = this.nodes.stream().collect(Collectors.groupingBy(n -> n.getSection().getSectionName()));
        int y = 3;
        for (Map.Entry<ResourceLocation, List<CompassNode>> entry : map.entrySet()) {
            listGroup.addWidget(new LabelWidget(2, y, entry.getKey().toLanguageKey("compass.section")));
            y += 12;
            int x = 0;
            for (CompassNode node : entry.getValue()) {
                IGuiTexture background = node.getBackground();
                IGuiTexture hoverBackground = node.getHoverBackground();
                IGuiTexture buttonTexture = node.getButtonTexture();
                ICompassUIConfig config = CompassManager.INSTANCE.getUIConfig(node.getSection().getSectionName().getNamespace());
                if (background == null) {
                    background = config.getNodeBackground();
                }
                if (hoverBackground == null) {
                    hoverBackground = config.getNodeHoverBackground();
                }
                listGroup.addWidget(new ButtonWidget(x + 2, y + 2, 20, 20, new GuiTextureGroup(background, new GuiTextureGroup(buttonTexture).scale(0.8f)), cd -> CompassManager.INSTANCE.openCompass(node)).setHoverTexture(new GuiTextureGroup(hoverBackground, new GuiTextureGroup(buttonTexture).scale(0.8f))).setHoverTooltips(node.getNodeName().toLanguageKey("compass.node")));
                if ((x += 25) <= 175) continue;
                x = 0;
                y += 25;
            }
            if (x == 0) continue;
            y += 25;
        }
    }
}

