/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component;

import com.lowdragmc.lowdraglib.gui.compass.ILayoutComponent;
import com.lowdragmc.lowdraglib.gui.compass.LayoutPageWidget;
import com.lowdragmc.lowdraglib.gui.compass.component.TextBoxComponent;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.ShaderTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.w3c.dom.Element;

public class ImageComponent
extends TextBoxComponent {
    protected int width = 50;
    protected int height = 50;
    protected float u0 = 0.0f;
    protected float v0 = 0.0f;
    protected float u1 = 1.0f;
    protected float v1 = 1.0f;
    protected IGuiTexture guiTexture = new ColorBorderTexture(-1, -1);

    @Override
    public ILayoutComponent fromXml(Element element) {
        this.width = XmlUtils.getAsInt(element, "width", this.width);
        this.height = XmlUtils.getAsInt(element, "height", this.height);
        this.u0 = XmlUtils.getAsFloat(element, "u0", this.u0);
        this.v0 = XmlUtils.getAsFloat(element, "v0", this.v0);
        this.u1 = XmlUtils.getAsFloat(element, "u1", this.u1);
        this.v1 = XmlUtils.getAsFloat(element, "v1", this.v1);
        String type = XmlUtils.getAsString(element, "type", "resource");
        String url = XmlUtils.getAsString(element, "url", "");
        this.guiTexture = switch (type) {
            case "resource" -> new ResourceTexture(url).getSubTexture(this.u0, this.v0, this.u1, this.v1);
            case "item" -> {
                XmlUtils.SizedIngredient item = XmlUtils.getIngredient(element);
                ItemStack[] items = (ItemStack[])Arrays.stream(item.ingredient().getItems()).map(i -> {
                    ItemStack copied = i.copy();
                    copied.setCount(item.count());
                    return copied;
                }).toArray(ItemStack[]::new);
                yield new ItemStackTexture(items);
            }
            case "shader" -> ShaderTexture.createShader(new ResourceLocation(url));
            default -> IGuiTexture.EMPTY;
        };
        this.isCenter = true;
        return super.fromXml(element);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayoutPageWidget addWidgets(LayoutPageWidget currentPage) {
        ImageWidget imageWidget = new ImageWidget(0, 0, this.width, this.height, this.guiTexture);
        if (this.hoverInfo != null) {
            imageWidget.setHoverTooltips(this.hoverInfo);
        }
        currentPage.addStreamWidget(this.wrapper(imageWidget));
        currentPage.addOffsetSpace(3);
        return super.addWidgets(currentPage);
    }
}

