/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component;

import com.lowdragmc.lowdraglib.gui.compass.ILayoutComponent;
import com.lowdragmc.lowdraglib.gui.compass.LayoutPageWidget;
import com.lowdragmc.lowdraglib.gui.compass.component.AbstractComponent;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IngredientComponent
extends AbstractComponent {
    List<Object> ingredients = new ArrayList<Object>();

    @Override
    public ILayoutComponent fromXml(Element element) {
        super.fromXml(element);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (e.getNodeName().equals("item")) {
                XmlUtils.SizedIngredient ingredient = XmlUtils.getIngredient(e);
                this.ingredients.add(ingredient);
            }
            if (!e.getNodeName().equals("fluid")) continue;
            FluidStack fluidStack = XmlUtils.getFluidStack(e);
            this.ingredients.add(fluidStack);
        }
        return this;
    }

    @Override
    protected LayoutPageWidget addWidgets(LayoutPageWidget currentPage) {
        if (this.ingredients.isEmpty()) {
            return currentPage;
        }
        WidgetGroup group = new WidgetGroup(0, 0, this.ingredients.size() * 20, 20);
        int x = 1;
        for (Object ingredient : this.ingredients) {
            if (ingredient instanceof XmlUtils.SizedIngredient) {
                XmlUtils.SizedIngredient item = (XmlUtils.SizedIngredient)ingredient;
                List<ItemStack> items = Arrays.stream(item.ingredient().getItems()).map(i -> {
                    ItemStack copied = i.copy();
                    copied.setCount(item.count());
                    return copied;
                }).toList();
                CycleItemStackHandler itemStackHandler = new CycleItemStackHandler(List.of(items));
                group.addWidget(new SlotWidget(itemStackHandler, 0, x, 1, false, false).setBackground(SlotWidget.ITEM_SLOT_TEXTURE));
            } else if (ingredient instanceof FluidStack) {
                FluidStack fluidStack = (FluidStack)ingredient;
                group.addWidget(new TankWidget(new FluidStorage(fluidStack), x, 1, false, false).setBackground((IGuiTexture)TankWidget.FLUID_SLOT_TEXTURE));
            }
            x += 20;
        }
        return currentPage.addStreamWidget(this.wrapper(group));
    }
}

