/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component.animation;

import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.Action;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.CompassScene;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnimationFrame {
    private int duration = -1;
    private int delay;
    private final List<Action> actions = new ArrayList<Action>();
    private final List<Component> tooltips = new ArrayList<Component>();
    private int[] actionTime = new int[0];

    public AnimationFrame() {
    }

    public AnimationFrame addActions(Action ... actions) {
        this.actions.addAll(Arrays.asList(actions));
        this.calculateActionTime();
        return this;
    }

    public AnimationFrame(int frameIndex, Element element) {
        this.duration = XmlUtils.getAsInt(element, "duration", -1);
        this.delay = XmlUtils.getAsInt(element, "delay", 0);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Action action;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element actionElement = (Element)node;
            if (actionElement.getNodeName().equals("description")) {
                this.tooltips.addAll(XmlUtils.getComponents(actionElement, Style.EMPTY));
            }
            if ((action = CompassManager.INSTANCE.createAction(actionElement)) == null) continue;
            this.actions.add(action);
        }
        this.calculateActionTime();
    }

    protected void calculateActionTime() {
        this.actionTime = new int[this.actions.size()];
        for (int i = 0; i < this.actions.size(); ++i) {
            Action action = this.actions.get(i);
            Action lastAction = i == 0 ? null : this.actions.get(i - 1);
            this.actionTime[i] = action.delay + (i == 0 ? 0 : this.actionTime[i - 1]);
            if (action.startBeforeLast) continue;
            int n = i;
            this.actionTime[n] = this.actionTime[n] + (lastAction == null ? 0 : lastAction.getDuration());
        }
    }

    public int getDuration() {
        return this.duration > 0 ? this.duration : (this.actionTime.length == 0 ? 0 : this.actionTime[this.actionTime.length - 1] + this.actions.get(this.actions.size() - 1).getDuration());
    }

    protected void onFrameStart(CompassScene scene) {
    }

    protected void onFrameEnd(CompassScene scene) {
    }

    public boolean onFrameTick(CompassScene scene, int frameTick) {
        if (frameTick == 0) {
            this.onFrameStart(scene);
        }
        if (frameTick >= this.getDuration()) {
            this.onFrameEnd(scene);
            return true;
        }
        for (int i = 0; i < this.actionTime.length; ++i) {
            if (this.actionTime[i] == frameTick) {
                this.actions.get(i).performAction(this, scene, true);
                continue;
            }
            if (this.actionTime[i] > frameTick) break;
        }
        return false;
    }

    public void performFrameResult(CompassScene compassScene) {
        for (Action action : this.actions) {
            action.performAction(this, compassScene, false);
        }
    }

    public AnimationFrame duration(int duration) {
        this.duration = duration;
        return this;
    }

    public int delay() {
        return this.delay;
    }

    public AnimationFrame delay(int delay) {
        this.delay = delay;
        return this;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public List<Component> tooltips() {
        return this.tooltips;
    }
}

