/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component.animation;

import com.lowdragmc.lowdraglib.gui.compass.component.animation.Action;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.AnimationFrame;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.BlockAnima;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.CompassScene;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.EntityInfo;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SceneAction
extends Action {
    private final List<Tuple<BlockAnima, BlockInfo>> addedBlocks = new ArrayList<Tuple<BlockAnima, BlockInfo>>();
    private final List<BlockAnima> removedBlocks = new ArrayList<BlockAnima>();
    private final Map<BlockPos, BlockInfo> modifiedTags = new HashMap<BlockPos, BlockInfo>();
    private final Map<BlockPosFace, Integer> highlightedBlocks = new HashMap<BlockPosFace, Integer>();
    private final List<Tuple<EntityInfo, Vec3>> addedEntities = new ArrayList<Tuple<EntityInfo, Vec3>>();
    private final List<Tuple<EntityInfo, Vec3>> modifiedEntities = new ArrayList<Tuple<EntityInfo, Vec3>>();
    private final List<Tuple<EntityInfo, Boolean>> removedEntities = new ArrayList<Tuple<EntityInfo, Boolean>>();
    private final Map<Vec3, MutableTriple<Tuple<XmlUtils.SizedIngredient, List<Component>>, Vec2, Integer>> tooltipBlocks = new HashMap<Vec3, MutableTriple<Tuple<XmlUtils.SizedIngredient, List<Component>>, Vec2, Integer>>();
    private Float rotation;
    private int duration = -1;

    public SceneAction() {
    }

    public SceneAction(Element element) {
        super(element);
        NodeList nodes = element.getChildNodes();
        block22: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element data = (Element)node;
            String nodeName = data.getNodeName();
            BlockPos blockPos = XmlUtils.getAsBlockPos(data, "pos", BlockPos.ZERO);
            Vec3 pos = XmlUtils.getAsVec3(data, "pos", Vec3.ZERO);
            switch (nodeName) {
                case "add": {
                    this.addedBlocks.add((Tuple<BlockAnima, BlockInfo>)new Tuple((Object)new BlockAnima(blockPos, XmlUtils.getAsVec3(data, "offset", new Vec3(0.0, 0.7, 0.0)), XmlUtils.getAsInt(data, "duration", 15)), (Object)XmlUtils.getBlockInfo(data)));
                    continue block22;
                }
                case "remove": {
                    this.removedBlocks.add(new BlockAnima(blockPos, XmlUtils.getAsVec3(data, "offset", new Vec3(0.0, 0.7, 0.0)), XmlUtils.getAsInt(data, "duration", 15)));
                    continue block22;
                }
                case "modify": {
                    this.modifiedTags.put(blockPos, XmlUtils.getBlockInfo(data));
                    continue block22;
                }
                case "add-entity": {
                    this.addedEntities.add((Tuple<EntityInfo, Vec3>)new Tuple((Object)XmlUtils.getEntityInfo(data), (Object)pos));
                    continue block22;
                }
                case "modify-entity": {
                    this.modifiedEntities.add((Tuple<EntityInfo, Vec3>)new Tuple((Object)XmlUtils.getEntityInfo(data), (Object)XmlUtils.getAsVec3(data, "pos", null)));
                    continue block22;
                }
                case "remove-entity": {
                    this.removedEntities.add((Tuple<EntityInfo, Boolean>)new Tuple((Object)XmlUtils.getEntityInfo(data), (Object)XmlUtils.getAsBoolean(data, "force", false)));
                    continue block22;
                }
                case "rotation": {
                    this.rotation = Float.valueOf(XmlUtils.getAsFloat(data, "degree", 0.0f));
                    continue block22;
                }
                case "highlight": {
                    this.highlightedBlocks.put(new BlockPosFace(blockPos, XmlUtils.getAsEnum(data, "face", Direction.class, null)), XmlUtils.getAsInt(data, "duration", 40));
                    continue block22;
                }
                case "tooltip": {
                    this.tooltipBlocks.put(XmlUtils.getAsVec3(data, "pos", new Vec3(0.0, 0.0, 0.0)), (MutableTriple<Tuple<XmlUtils.SizedIngredient, List<Component>>, Vec2, Integer>)MutableTriple.of((Object)new Tuple((Object)XmlUtils.getIngredient(data), new ArrayList<MutableComponent>(XmlUtils.getComponents(data, Style.EMPTY))), (Object)XmlUtils.getAsVec2(data, "screen-offset", new Vec2(0.3f, 0.3f)), (Object)XmlUtils.getAsInt(data, "duration", 40)));
                }
            }
        }
    }

    public SceneAction rotation(Float rotation) {
        this.rotation = rotation;
        return this;
    }

    public SceneAction addedBlock(BlockPos pos, BlockInfo blockInfo, Vec3 offset, int duration) {
        this.addedBlocks.add((Tuple<BlockAnima, BlockInfo>)new Tuple((Object)new BlockAnima(pos, offset, duration), (Object)blockInfo));
        return this;
    }

    public SceneAction removedBlock(BlockPos pos, Vec3 offset, int duration) {
        this.removedBlocks.add(new BlockAnima(pos, offset, duration));
        return this;
    }

    public SceneAction modifiedTag(BlockPos pos, BlockInfo blockInfo) {
        this.modifiedTags.put(pos, blockInfo);
        return this;
    }

    public SceneAction highlightedBlock(BlockPos pos, Direction face, int duration) {
        this.highlightedBlocks.put(new BlockPosFace(pos, face), duration);
        return this;
    }

    public SceneAction addedEntity(EntityInfo entityInfo, Vec3 pos) {
        this.addedEntities.add((Tuple<EntityInfo, Vec3>)new Tuple((Object)entityInfo, (Object)pos));
        return this;
    }

    public SceneAction modifiedEntity(EntityInfo entityInfo, Vec3 pos) {
        this.modifiedEntities.add((Tuple<EntityInfo, Vec3>)new Tuple((Object)entityInfo, (Object)pos));
        return this;
    }

    public SceneAction removedEntity(EntityInfo entityInfo, boolean force) {
        this.removedEntities.add((Tuple<EntityInfo, Boolean>)new Tuple((Object)entityInfo, (Object)force));
        return this;
    }

    public SceneAction tooltip(Vec3 pos, Tuple<XmlUtils.SizedIngredient, List<Component>> tooltip, Vec2 screenOffset, int duration) {
        this.tooltipBlocks.put(pos, (MutableTriple<Tuple<XmlUtils.SizedIngredient, List<Component>>, Vec2, Integer>)MutableTriple.of(tooltip, (Object)screenOffset, (Object)duration));
        return this;
    }

    @Override
    public int getDuration() {
        if (this.duration == -1) {
            this.duration = 0;
            for (Tuple<BlockAnima, BlockInfo> tuple : this.addedBlocks) {
                this.duration = Math.max(this.duration, ((BlockAnima)tuple.getA()).duration());
            }
            for (BlockAnima blockAnima : this.removedBlocks) {
                this.duration = Math.max(this.duration, blockAnima.duration());
            }
            for (Map.Entry entry : this.highlightedBlocks.entrySet()) {
                this.duration = Math.max(this.duration, (Integer)entry.getValue());
            }
            for (Map.Entry entry : this.tooltipBlocks.entrySet()) {
                this.duration = Math.max(this.duration, (Integer)((MutableTriple)entry.getValue()).getRight());
            }
        }
        return this.duration + 5;
    }

    @Override
    public void performAction(AnimationFrame frame, CompassScene scene, boolean anima) {
        Vec3 pos;
        for (Tuple<BlockAnima, BlockInfo> tuple : this.addedBlocks) {
            BlockInfo blockInfo = (BlockInfo)tuple.getB();
            blockInfo.clearBlockEntityCache();
            scene.addBlock(((BlockAnima)tuple.getA()).pos(), blockInfo, anima ? (BlockAnima)tuple.getA() : null);
        }
        for (BlockInfo blockInfo : this.modifiedTags.values()) {
            blockInfo.clearBlockEntityCache();
        }
        for (BlockAnima blockAnima : this.removedBlocks) {
            scene.removeBlock(blockAnima.pos(), anima ? blockAnima : null);
        }
        for (Map.Entry entry : this.modifiedTags.entrySet()) {
            scene.addBlock((BlockPos)entry.getKey(), (BlockInfo)entry.getValue(), null);
        }
        for (Tuple tuple : this.addedEntities) {
            pos = (Vec3)tuple.getB();
            scene.addEntity((EntityInfo)tuple.getA(), pos, false);
        }
        for (Tuple tuple : this.modifiedEntities) {
            pos = (Vec3)tuple.getB();
            scene.addEntity((EntityInfo)tuple.getA(), pos, true);
        }
        for (Tuple tuple : this.removedEntities) {
            scene.removeEntity((EntityInfo)tuple.getA(), (Boolean)tuple.getB());
        }
        if (anima) {
            for (Map.Entry entry : this.highlightedBlocks.entrySet()) {
                scene.highlightBlock((BlockPosFace)entry.getKey(), (Integer)entry.getValue());
            }
        }
        if (anima) {
            for (Map.Entry entry : this.tooltipBlocks.entrySet()) {
                scene.addTooltip((Vec3)entry.getKey(), (Tuple<XmlUtils.SizedIngredient, List<Component>>)((Tuple)((MutableTriple)entry.getValue()).getLeft()), (Vec2)((MutableTriple)entry.getValue()).getMiddle(), (Integer)((MutableTriple)entry.getValue()).getRight());
            }
        }
        if (this.rotation != null) {
            scene.rotate(this.rotation.floatValue(), anima);
        }
    }
}

