/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.accessors;

import com.lowdragmc.lowdraglib.gui.editor.accessors.IConfiguratorAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSelector;
import com.lowdragmc.lowdraglib.gui.editor.annotation.DefaultValue;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SelectorConfigurator;
import com.lowdragmc.lowdraglib.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.StringRepresentable;
import org.apache.commons.lang3.ArrayUtils;

@ConfigAccessor
public class EnumAccessor
implements IConfiguratorAccessor<Enum> {
    @Override
    public boolean test(Class<?> type) {
        return type.isEnum();
    }

    @Override
    public Enum defaultValue(Field field, Class<?> type) {
        if (field.isAnnotationPresent(DefaultValue.class)) {
            String name = field.getAnnotation(DefaultValue.class).stringValue()[0];
            for (Object value : type.getEnumConstants()) {
                String enumName = EnumAccessor.getEnumName((Enum)value);
                if (!enumName.equals(name)) continue;
                return (Enum)value;
            }
        }
        return (Enum)type.getEnumConstants()[0];
    }

    @Override
    public Configurator create(String name, Supplier<Enum> supplier, Consumer<Enum> consumer, boolean forceUpdate, Field field) {
        Class<?> type = ReflectionUtils.getRawType(field.getGenericType());
        if (type.isEnum()) {
            ConfigSelector configSelector;
            String[] candidate;
            Stream<Enum> candidates = Arrays.stream(type.getEnumConstants()).map(Enum.class::cast);
            if (field.isAnnotationPresent(ConfigSelector.class) && (candidate = (configSelector = field.getAnnotation(ConfigSelector.class)).candidate()).length > 0) {
                candidates = candidates.filter(e -> ArrayUtils.contains((Object[])candidate, (Object)EnumAccessor.getEnumName(e)));
            }
            return new SelectorConfigurator<Enum>(name, supplier, consumer, (Enum)this.defaultValue(field, (Class)type), forceUpdate, candidates.toList(), EnumAccessor::getEnumName);
        }
        return IConfiguratorAccessor.super.create(name, supplier, consumer, forceUpdate, field);
    }

    public static String getEnumName(Enum enumValue) {
        if (enumValue instanceof StringRepresentable) {
            StringRepresentable provider = (StringRepresentable)enumValue;
            return provider.getSerializedName();
        }
        return enumValue.name();
    }
}

