/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.phys.AABB;

public class AABBConfigurator
extends ValueConfigurator<AABB> {
    public AABBConfigurator(String name, Supplier<AABB> supplier, Consumer<AABB> onUpdate, AABB defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        this.setSize(new Size(200, 30));
        if (this.value == null) {
            this.value = defaultValue;
        }
    }

    @Override
    protected void onValueUpdate(AABB newValue) {
        if (newValue == null) {
            newValue = (AABB)this.defaultValue;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
    }

    @Override
    public void init(int width) {
        super.init(width);
        assert (this.value != null);
        int w = (width - this.leftWidth - this.rightWidth) / 3;
        NumberConfigurator minX = new NumberConfigurator("minX", () -> ((AABB)this.value).minX, number -> {
            AABB newValue = new AABB(number.doubleValue(), ((AABB)this.value).minY, ((AABB)this.value).minZ, ((AABB)this.value).maxX, ((AABB)this.value).maxY, ((AABB)this.value).maxZ);
            this.onValueUpdate(newValue);
            this.updateValue();
        }, ((AABB)this.defaultValue).minX, this.forceUpdate);
        minX.setRange(-1.7976931348623157E308, Double.MAX_VALUE);
        minX.setWheel(0.1);
        minX.setConfiguratorContainer(this.configuratorContainer);
        minX.init(w);
        minX.addSelfPosition(this.leftWidth, 0);
        this.addWidget(minX);
        NumberConfigurator minY = new NumberConfigurator("minY", () -> ((AABB)this.value).minY, number -> {
            AABB newValue = new AABB(((AABB)this.value).minX, number.doubleValue(), ((AABB)this.value).minZ, ((AABB)this.value).maxX, ((AABB)this.value).maxY, ((AABB)this.value).maxZ);
            this.onValueUpdate(newValue);
            this.updateValue();
        }, ((AABB)this.defaultValue).minY, this.forceUpdate);
        minY.setRange(-1.7976931348623157E308, Double.MAX_VALUE);
        minY.setWheel(0.1);
        minY.setConfiguratorContainer(this.configuratorContainer);
        minY.init(w);
        minY.addSelfPosition(this.leftWidth + w, 0);
        this.addWidget(minY);
        NumberConfigurator minZ = new NumberConfigurator("minZ", () -> ((AABB)this.value).minZ, number -> {
            AABB newValue = new AABB(((AABB)this.value).minX, ((AABB)this.value).minY, number.doubleValue(), ((AABB)this.value).maxX, ((AABB)this.value).maxY, ((AABB)this.value).maxZ);
            this.onValueUpdate(newValue);
            this.updateValue();
        }, ((AABB)this.defaultValue).minZ, this.forceUpdate);
        minZ.setRange(-1.7976931348623157E308, Double.MAX_VALUE);
        minZ.setWheel(0.1);
        minZ.setConfiguratorContainer(this.configuratorContainer);
        minZ.init(w);
        minZ.addSelfPosition(this.leftWidth + w * 2, 0);
        this.addWidget(minZ);
        NumberConfigurator maxX = new NumberConfigurator("maxX", () -> ((AABB)this.value).maxX, number -> {
            AABB newValue = new AABB(((AABB)this.value).minX, ((AABB)this.value).minY, ((AABB)this.value).minZ, number.doubleValue(), ((AABB)this.value).maxY, ((AABB)this.value).maxZ);
            this.onValueUpdate(newValue);
            this.updateValue();
        }, ((AABB)this.defaultValue).maxX, this.forceUpdate);
        maxX.setRange(-1.7976931348623157E308, Double.MAX_VALUE);
        maxX.setWheel(0.1);
        maxX.setConfiguratorContainer(this.configuratorContainer);
        maxX.init(w);
        maxX.addSelfPosition(this.leftWidth, 15);
        this.addWidget(maxX);
        NumberConfigurator maxY = new NumberConfigurator("maxY", () -> ((AABB)this.value).maxY, number -> {
            AABB newValue = new AABB(((AABB)this.value).minX, ((AABB)this.value).minY, ((AABB)this.value).minZ, ((AABB)this.value).maxX, number.doubleValue(), ((AABB)this.value).maxZ);
            this.onValueUpdate(newValue);
            this.updateValue();
        }, ((AABB)this.defaultValue).maxY, this.forceUpdate);
        maxY.setRange(-1.7976931348623157E308, Double.MAX_VALUE);
        maxY.setWheel(0.1);
        maxY.setConfiguratorContainer(this.configuratorContainer);
        maxY.init(w);
        maxY.addSelfPosition(this.leftWidth + w, 15);
        this.addWidget(maxY);
        NumberConfigurator maxZ = new NumberConfigurator("maxZ", () -> ((AABB)this.value).maxZ, number -> {
            AABB newValue = new AABB(((AABB)this.value).minX, ((AABB)this.value).minY, ((AABB)this.value).minZ, ((AABB)this.value).maxX, ((AABB)this.value).maxY, number.doubleValue());
            this.onValueUpdate(newValue);
            this.updateValue();
        }, ((AABB)this.defaultValue).maxZ, this.forceUpdate);
        maxZ.setRange(-1.7976931348623157E308, Double.MAX_VALUE);
        maxZ.setWheel(0.1);
        maxZ.setConfiguratorContainer(this.configuratorContainer);
        maxZ.init(w);
        maxZ.addSelfPosition(this.leftWidth + w * 2, 15);
        this.addWidget(maxZ);
    }
}

