/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.runtime.PersistedParser;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.UIResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public interface IConfigurableWidget
extends IConfigurable {
    public static final Function<String, AnnotationDetector.Wrapper<LDLRegister, IConfigurableWidget>> CACHE = Util.memoize(type -> {
        for (AnnotationDetector.Wrapper<LDLRegister, IConfigurableWidget> wrapper : AnnotationDetector.REGISTER_WIDGETS) {
            if (!wrapper.annotation().name().equals(type)) continue;
            return wrapper;
        }
        return null;
    });

    default public Widget widget() {
        return (Widget)((Object)this);
    }

    default public void initTemplate() {
    }

    default public boolean canDragIn(Object dragging) {
        if (dragging instanceof IGuiTexture) {
            return true;
        }
        if (dragging instanceof String) {
            return true;
        }
        if (dragging instanceof IIdProvider) {
            return true;
        }
        return dragging instanceof Integer;
    }

    default public boolean handleDragging(Object dragging) {
        if (dragging instanceof IGuiTexture) {
            IGuiTexture guiTexture = (IGuiTexture)dragging;
            this.widget().setBackground(guiTexture);
            return true;
        }
        if (dragging instanceof String) {
            String string = (String)dragging;
            this.widget().setHoverTooltips(string);
            return true;
        }
        if (dragging instanceof IIdProvider) {
            IIdProvider idProvider = (IIdProvider)dragging;
            this.widget().setId((String)idProvider.get());
            return true;
        }
        if (dragging instanceof Integer) {
            Integer color = (Integer)dragging;
            this.widget().setBackground(new ColorRectTexture(color));
            return true;
        }
        return false;
    }

    public static CompoundTag serializeNBT(IConfigurableWidget widget, Resources resources, boolean isProject) {
        return IConfigurableWidget.serializeNBT(widget, resources.resources.get("ldlib.gui.editor.group.textures"), isProject);
    }

    public static CompoundTag serializeNBT(IConfigurableWidget widget, Resource<IGuiTexture> resources, boolean isProject) {
        UIResourceTexture.setCurrentResource(resources, isProject);
        CompoundTag tag = widget.serializeInnerNBT();
        UIResourceTexture.clearCurrentResource();
        return tag;
    }

    public static void deserializeNBT(IConfigurableWidget widget, CompoundTag tag, Resources resources, boolean isProject) {
        IConfigurableWidget.deserializeNBT(widget, tag, resources.resources.get("ldlib.gui.editor.group.textures"), isProject);
    }

    public static void deserializeNBT(IConfigurableWidget widget, CompoundTag tag, Resource<IGuiTexture> resources, boolean isProject) {
        UIResourceTexture.setCurrentResource(resources, isProject);
        widget.deserializeInnerNBT(tag);
        UIResourceTexture.clearCurrentResource();
    }

    default public CompoundTag serializeInnerNBT() {
        CompoundTag tag = new CompoundTag();
        PersistedParser.serializeNBT(tag, this.getClass(), this);
        return tag;
    }

    default public void deserializeInnerNBT(CompoundTag nbt) {
        PersistedParser.deserializeNBT(nbt, new HashMap<String, Method>(), this.getClass(), this);
    }

    default public CompoundTag serializeWrapper() {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", this.name());
        tag.put("data", (Tag)this.serializeInnerNBT());
        return tag;
    }

    @Nullable
    public static IConfigurableWidget deserializeWrapper(CompoundTag tag) {
        String type = tag.getString("type");
        AnnotationDetector.Wrapper<LDLRegister, IConfigurableWidget> wrapper = CACHE.apply(type);
        if (wrapper != null) {
            IConfigurableWidget child = wrapper.creator().get();
            child.deserializeInnerNBT(tag.getCompound("data"));
            return child;
        }
        return null;
    }

    @FunctionalInterface
    public static interface IIdProvider
    extends Supplier<String> {
    }
}

