/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SearchComponentWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemConfigurator
extends ValueConfigurator<Item>
implements SearchComponentWidget.IWidgetSearch<Item> {
    protected SearchComponentWidget<Item> searchComponent;
    protected ImageWidget image;

    public ItemConfigurator(String name, Supplier<Item> supplier, Consumer<Item> onUpdate, @Nonnull Item defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (this.value == null) {
            this.value = defaultValue;
        }
    }

    @Override
    protected void onValueUpdate(Item newValue) {
        if (newValue == null) {
            newValue = (Item)this.defaultValue;
        }
        if (this.value == newValue) {
            return;
        }
        super.onValueUpdate(newValue);
        this.searchComponent.setCurrent(this.value == null ? (Item)this.defaultValue : (Item)this.value);
    }

    @Override
    public void init(int width) {
        super.init(width);
        this.image = new ImageWidget(this.leftWidth, 2, width - this.leftWidth - 3 - this.rightWidth, 10, ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        this.addWidget(this.image);
        this.image.setDraggingConsumer(o -> o instanceof ItemLike || o instanceof ItemStack, o -> this.image.setImage(ColorPattern.GREEN.rectTexture().setRadius(5.0f)), o -> this.image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)), o -> {
            if (o instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)o;
                this.onValueUpdate(itemStack.getItem());
                this.updateValue();
            } else if (o instanceof ItemLike) {
                ItemLike item = (ItemLike)o;
                this.onValueUpdate(item.asItem());
                this.updateValue();
            }
            this.image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        });
        this.searchComponent = new SearchComponentWidget<Item>(this.leftWidth + 3, 2, width - this.leftWidth - 6 - this.rightWidth, 10, this);
        this.addWidget(this.searchComponent);
        this.searchComponent.setIconProvider(item -> new ItemStackTexture(new ItemStack((ItemLike)item)));
        this.searchComponent.setShowUp(true);
        this.searchComponent.setCapacity(5);
        this.searchComponent.setCurrent((Item)this.value);
        TextFieldWidget textFieldWidget = this.searchComponent.textFieldWidget;
        textFieldWidget.setClientSideWidget();
        textFieldWidget.setBordered(false);
    }

    @Override
    public String resultDisplay(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).toString();
    }

    @Override
    public void selectResult(Item item) {
        this.onValueUpdate(item);
        this.updateValue();
    }

    @Override
    public void search(String word, Consumer<Item> find) {
        String wordLower = word.toLowerCase();
        for (Map.Entry itemEntry : BuiltInRegistries.ITEM.entrySet()) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Item item = (Item)itemEntry.getValue();
            ResourceLocation id = ((ResourceKey)itemEntry.getKey()).location();
            if (id.toString().contains(wordLower)) {
                find.accept(item);
                continue;
            }
            String name = LocalizationUtils.format(item.getDescriptionId(), new Object[0]);
            if (!name.toLowerCase().contains(wordLower)) continue;
            find.accept(item);
        }
    }
}

